/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.model.geo.ProcessedVisit;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class HomeDetectionService {
    public Optional<ProcessedVisit> findAccommodation(List<ProcessedVisit> visits, Instant memoryStart, Instant memoryEnd) {
        HashMap<Long, Long> sleepingHoursDuration = new HashMap<Long, Long>();
        for (ProcessedVisit visit2 : visits) {
            long durationInSleepingHours = this.calculateSleepingHoursDuration(visit2, memoryStart, memoryEnd);
            if (durationInSleepingHours <= 0L) continue;
            sleepingHoursDuration.merge(visit2.getPlace().getId(), durationInSleepingHours, Long::sum);
        }
        if (sleepingHoursDuration.isEmpty()) {
            return Optional.empty();
        }
        long maxDuration = sleepingHoursDuration.values().stream().max(Long::compare).orElse(0L);
        List<ProcessedVisit> candidates = visits.stream().filter(visit -> sleepingHoursDuration.getOrDefault(visit.getPlace().getId(), 0L) == maxDuration).toList();
        return candidates.stream().min((v1, v2) -> {
            long diff1 = Math.abs(Duration.between(v1.getEndTime(), memoryEnd).getSeconds());
            long diff2 = Math.abs(Duration.between(v2.getEndTime(), memoryEnd).getSeconds());
            return Long.compare(diff1, diff2);
        });
    }

    private long calculateSleepingHoursDuration(ProcessedVisit visit, Instant notBefore, Instant notAfter) {
        ZoneId timeZone = visit.getPlace().getTimezone();
        if (timeZone == null) {
            timeZone = ZoneId.systemDefault();
        }
        Instant constrainedStart = visit.getStartTime().isBefore(notBefore) ? notBefore : visit.getStartTime();
        Instant constrainedEnd = visit.getEndTime().isAfter(notAfter) ? notAfter : visit.getEndTime();
        ZonedDateTime startLocal = constrainedStart.atZone(timeZone);
        ZonedDateTime endLocal = constrainedEnd.atZone(timeZone);
        long totalSleepingDuration = 0L;
        LocalDate currentDay = startLocal.toLocalDate();
        LocalDate lastDay = endLocal.toLocalDate();
        while (!currentDay.isAfter(lastDay)) {
            ZonedDateTime overlapEnd;
            ZonedDateTime sleepStart = currentDay.atTime(22, 0).atZone(timeZone);
            ZonedDateTime sleepEnd = currentDay.plusDays(1L).atTime(6, 0).atZone(timeZone);
            ZonedDateTime overlapStart = sleepStart.isAfter(startLocal) ? sleepStart : startLocal;
            ZonedDateTime zonedDateTime = overlapEnd = sleepEnd.isBefore(endLocal) ? sleepEnd : endLocal;
            if (overlapStart.isBefore(overlapEnd)) {
                totalSleepingDuration += Duration.between(overlapStart, overlapEnd).getSeconds();
            }
            currentDay = currentDay.plusDays(1L);
        }
        return totalSleepingDuration;
    }
}

