/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import java.text.MessageFormat;
import java.time.Duration;
import java.util.Locale;
import java.util.ResourceBundle;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class I18nService {
    private final MessageSource messageSource;

    public I18nService(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String humanizeDuration(long seconds) {
        Duration duration = Duration.ofSeconds(seconds);
        return this.humanizeDuration(duration);
    }

    public String humanizeDuration(Duration duration) {
        long hours = duration.toHours();
        long minutesPart = duration.toMinutesPart();
        Locale locale = LocaleContextHolder.getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle("messages", locale);
        if (hours > 0L) {
            String pattern = bundle.getString("format.hours_minutes");
            return new MessageFormat(pattern, locale).format(new Object[]{hours, minutesPart});
        }
        long totalMinutes = duration.toMinutes();
        if (totalMinutes == 0L) {
            return "Less than a minute";
        }
        String pattern = bundle.getString("format.minutes_only");
        return new MessageFormat(pattern, locale).format(new Object[]{totalMinutes});
    }

    public String translate(String messageKey) {
        return this.messageSource.getMessage(messageKey, null, LocaleContextHolder.getLocale());
    }

    public String translateWithDefault(String messageKey, String defaultMessage) {
        return this.messageSource.getMessage(messageKey, null, defaultMessage, LocaleContextHolder.getLocale());
    }

    public String translate(String messageKey, Object ... args) {
        return this.messageSource.getMessage(messageKey, args, LocaleContextHolder.getLocale());
    }
}

