/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.ImportProcessor;
import com.dedicatedcode.reitti.service.LocationBatchingService;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class LocationBatchingService {
    private static final Logger logger = LoggerFactory.getLogger(LocationBatchingService.class);
    private final ImportProcessor importProcessor;
    private final Map<String, UserBatch> userBatches = new ConcurrentHashMap();
    private final ReentrantLock flushLock = new ReentrantLock();
    @Value(value="${reitti.batching.max-batch-size:100}")
    private int maxBatchSize;
    @Value(value="${reitti.batching.max-wait-time-ms:5000}")
    private long maxWaitTimeMs;

    @Autowired
    public LocationBatchingService(ImportProcessor importProcessor) {
        this.importProcessor = importProcessor;
    }

    public void addLocationPoint(User user, LocationPoint locationPoint) {
        String username = user.getUsername();
        this.userBatches.compute(username, (key, existingBatch) -> {
            if (existingBatch == null) {
                existingBatch = new UserBatch(user);
            }
            existingBatch.addLocationPoint(locationPoint);
            if (existingBatch.shouldFlush(this.maxBatchSize, this.maxWaitTimeMs)) {
                this.flushBatch(username, existingBatch);
                return new UserBatch(user);
            }
            return existingBatch;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${reitti.batching.flush-interval-ms:2000}")
    public void flushExpiredBatches() {
        this.flushLock.lock();
        try {
            ArrayList usersToFlush = new ArrayList();
            this.userBatches.forEach((username, batch) -> {
                if (batch.shouldFlush(this.maxBatchSize, this.maxWaitTimeMs)) {
                    usersToFlush.add(username);
                }
            });
            for (String username2 : usersToFlush) {
                UserBatch batch2 = (UserBatch)this.userBatches.remove(username2);
                if (batch2 == null || batch2.isEmpty()) continue;
                this.flushBatch(username2, batch2);
            }
        }
        finally {
            this.flushLock.unlock();
        }
    }

    @PreDestroy
    @EventListener(value={ContextClosedEvent.class})
    public void flushAllBatches() {
        logger.info("Application shutting down, flushing all pending location batches");
        this.flushLock.lock();
        try {
            this.userBatches.forEach((username, batch) -> {
                if (!batch.isEmpty()) {
                    this.flushBatch(username, batch);
                }
            });
            this.userBatches.clear();
        }
        finally {
            this.flushLock.unlock();
        }
    }

    private void flushBatch(String username, UserBatch batch) {
        if (batch.isEmpty()) {
            return;
        }
        try {
            List points = batch.getLocationPoints();
            logger.debug("Flushing batch of {} location points for user {}", (Object)points.size(), (Object)username);
            this.importProcessor.processBatch(batch.getUser(), points);
        }
        catch (Exception e) {
            logger.error("Error flushing batch for user {}", (Object)username, (Object)e);
        }
    }
}

