/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.service.LocationPointsSimplificationService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LocationPointsSimplificationService {
    private static final Logger logger = LoggerFactory.getLogger(LocationPointsSimplificationService.class);

    public List<LocationPoint> simplifyPoints(List<LocationPoint> points, Integer zoom) {
        if (zoom == null || points.size() <= 2) {
            return points;
        }
        int targetPointCount = this.calculateTargetPointCount(points.size(), zoom.intValue());
        if (targetPointCount >= points.size()) {
            return points;
        }
        logger.trace("Simplifying {} points to {} points for zoom level {}", new Object[]{points.size(), targetPointCount, zoom});
        return this.visvalingamWhyatt(points, targetPointCount);
    }

    private int calculateTargetPointCount(int originalCount, int zoom) {
        double retentionRatio = zoom <= 13 ? 0.1 + (double)(zoom - 1) * 0.025 : (zoom <= 15 ? 0.2 + (double)(zoom - 6) * 0.04 : (zoom <= 18 ? 0.4 + (double)(zoom - 11) * 0.06 : 0.7 + (double)Math.min(zoom - 16, 4) * 0.075));
        int targetCount = (int)Math.ceil((double)originalCount * retentionRatio);
        targetCount = Math.min(3000, targetCount);
        return Math.max(10, Math.min(targetCount, originalCount));
    }

    private List<LocationPoint> visvalingamWhyatt(List<LocationPoint> points, int targetCount) {
        if (points.size() <= targetCount) {
            return points;
        }
        ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        for (int i = 1; i < points.size() - 1; ++i) {
            Triangle triangle = new Triangle(i - 1, i, i + 1, points);
            triangles.add(triangle);
        }
        PriorityQueue<Triangle> heap = new PriorityQueue<Triangle>(Comparator.comparingDouble(t -> t.area));
        heap.addAll(triangles);
        HashSet<Integer> removedIndices = new HashSet<Integer>();
        int pointsToRemove = points.size() - targetCount;
        while (pointsToRemove > 0 && !heap.isEmpty()) {
            Triangle minTriangle = heap.poll();
            if (removedIndices.contains(minTriangle.centerIndex)) continue;
            removedIndices.add(minTriangle.centerIndex);
            --pointsToRemove;
            this.updateNeighboringTriangles(heap, minTriangle, removedIndices, points);
        }
        ArrayList<LocationPoint> result = new ArrayList<LocationPoint>();
        for (int i = 0; i < points.size(); ++i) {
            if (removedIndices.contains(i)) continue;
            result.add(points.get(i));
        }
        return result;
    }

    private void updateNeighboringTriangles(PriorityQueue<Triangle> heap, Triangle removed, Set<Integer> removedIndices, List<LocationPoint> points) {
        Triangle newTriangle;
        int nextIndex;
        int prevIndex;
        for (prevIndex = removed.leftIndex; prevIndex > 0 && removedIndices.contains(prevIndex); --prevIndex) {
        }
        for (nextIndex = removed.rightIndex; nextIndex < points.size() - 1 && removedIndices.contains(nextIndex); ++nextIndex) {
        }
        if (prevIndex > 0 && !removedIndices.contains(prevIndex - 1)) {
            newTriangle = new Triangle(prevIndex - 1, prevIndex, nextIndex, points);
            heap.add(newTriangle);
        }
        if (nextIndex < points.size() - 1 && !removedIndices.contains(nextIndex + 1)) {
            newTriangle = new Triangle(prevIndex, nextIndex, nextIndex + 1, points);
            heap.add(newTriangle);
        }
    }
}

