/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.dto.PhotoResponse;
import com.dedicatedcode.reitti.model.geo.GeoUtils;
import com.dedicatedcode.reitti.model.geo.ProcessedVisit;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.geo.Trip;
import com.dedicatedcode.reitti.model.memory.BlockType;
import com.dedicatedcode.reitti.model.memory.Memory;
import com.dedicatedcode.reitti.model.memory.MemoryBlockImageGallery;
import com.dedicatedcode.reitti.model.memory.MemoryBlockPart;
import com.dedicatedcode.reitti.model.memory.MemoryBlockText;
import com.dedicatedcode.reitti.model.memory.MemoryClusterBlock;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.service.HomeDetectionService;
import com.dedicatedcode.reitti.service.I18nService;
import com.dedicatedcode.reitti.service.MemoryBlockGenerationService;
import com.dedicatedcode.reitti.service.StorageService;
import com.dedicatedcode.reitti.service.integration.ImmichIntegrationService;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MemoryBlockGenerationService {
    private static final Logger log = LoggerFactory.getLogger(MemoryBlockGenerationService.class);
    private static final DateTimeFormatter FULL_DATE_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd MMM");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final long MIN_VISIT_DURATION_SECONDS = 600L;
    private static final double WEIGHT_DURATION = 1.0;
    private static final double WEIGHT_DISTANCE = 2.0;
    private static final double WEIGHT_CATEGORY = 3.0;
    private static final double WEIGHT_NOVELTY = 1.5;
    private static final long CLUSTER_TIME_THRESHOLD_SECONDS = 7200L;
    private static final double CLUSTER_DISTANCE_THRESHOLD_METERS = 1000.0;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final TripJdbcService tripJdbcService;
    private final I18nService i18n;
    private final ImmichIntegrationService immichIntegrationService;
    private final StorageService storageService;
    private final HomeDetectionService homeDetectionService;

    public MemoryBlockGenerationService(ProcessedVisitJdbcService processedVisitJdbcService, TripJdbcService tripJdbcService, I18nService i18nService, ImmichIntegrationService immichIntegrationService, StorageService storageService, HomeDetectionService homeDetectionService) {
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.tripJdbcService = tripJdbcService;
        this.i18n = i18nService;
        this.immichIntegrationService = immichIntegrationService;
        this.storageService = storageService;
        this.homeDetectionService = homeDetectionService;
    }

    public List<MemoryBlockPart> generate(User user, Memory memory, ZoneId timeZone) {
        Instant startDate = memory.getStartDate();
        Instant endDate = memory.getEndDate();
        List allVisitsInRange = this.processedVisitJdbcService.findByUserAndTimeOverlap(user, startDate, endDate);
        List allTripsInRange = this.tripJdbcService.findByUserAndTimeOverlap(user, startDate, endDate);
        Optional accommodation = this.homeDetectionService.findAccommodation(allVisitsInRange, startDate, endDate);
        Optional homeBefore = this.homeDetectionService.findAccommodation(this.processedVisitJdbcService.findByUserAndTimeOverlap(user, startDate.minus(7L, ChronoUnit.DAYS), startDate), startDate.minus(7L, ChronoUnit.DAYS), startDate);
        Optional homeAfter = this.homeDetectionService.findAccommodation(this.processedVisitJdbcService.findByUserAndTimeOverlap(user, endDate, endDate.plus(7L, ChronoUnit.DAYS)), endDate, endDate.plus(7L, ChronoUnit.DAYS));
        Instant firstAccommodationArrival = accommodation.flatMap(p -> allVisitsInRange.stream().filter(visit -> visit.getPlace().getId().equals(p.getPlace().getId())).min(Comparator.comparing(ProcessedVisit::getStartTime))).map(ProcessedVisit::getStartTime).orElse(null);
        Instant lastAccommodationDeparture = accommodation.flatMap(p -> allVisitsInRange.stream().filter(visit -> visit.getPlace().getId().equals(p.getPlace().getId())).max(Comparator.comparing(ProcessedVisit::getStartTime))).map(ProcessedVisit::getStartTime).orElse(null);
        List filteredVisits = accommodation.map(a -> this.filterVisits(allVisitsInRange, a)).orElse(allVisitsInRange);
        log.info("Found {} visits after filtering (accommodation: {})", (Object)filteredVisits.size(), (Object)accommodation.map(a -> a.getPlace().getName()).orElse("none"));
        List scoredVisits = this.scoreVisits(filteredVisits, (ProcessedVisit)accommodation.orElse(null));
        scoredVisits.sort(Comparator.comparingDouble(ScoredVisit::score).reversed());
        log.info("Scored {} visits, top score: {}", (Object)scoredVisits.size(), (Object)(scoredVisits.isEmpty() ? 0.0 : ((ScoredVisit)scoredVisits.getFirst()).score()));
        List clusters = this.clusterVisits(scoredVisits);
        log.info("Created {} clusters from visits", (Object)clusters.size());
        ArrayList<MemoryBlockPart> blockParts = new ArrayList<MemoryBlockPart>();
        if (!clusters.isEmpty() && accommodation.isPresent() && homeBefore.isPresent()) {
            String introText = this.generateIntroductionText(memory, clusters, (ProcessedVisit)accommodation.orElse(null), (ProcessedVisit)homeBefore.orElse(null), startDate, endDate, timeZone);
            MemoryBlockText introBlock = new MemoryBlockText(null, this.i18n.translate("memory.generator.headline.text"), introText);
            blockParts.add((MemoryBlockPart)introBlock);
        }
        if (firstAccommodationArrival != null) {
            List<Trip> tripsToAccommodation = allTripsInRange.stream().filter(trip -> trip.getEndTime() != null && !trip.getEndTime().isAfter(firstAccommodationArrival)).filter(trip -> trip.getStartTime() != null && !trip.getStartTime().isBefore(startDate)).sorted(Comparator.comparing(Trip::getStartTime)).toList();
            if (!tripsToAccommodation.isEmpty()) {
                String formattedStartDate = MemoryBlockGenerationService.formatTime((Instant)tripsToAccommodation.getFirst().getStartTime(), (ZoneId)timeZone);
                String formattedEndDate = MemoryBlockGenerationService.formatTime((Instant)tripsToAccommodation.getLast().getEndTime(), (ZoneId)timeZone);
                String text = this.i18n.translate("memory.generator.travel_to_accommodation.text", new Object[]{homeBefore.map(h -> h.getPlace().getCity()).orElse(""), formattedStartDate, accommodation.map(a -> a.getPlace().getCity()).orElse(""), formattedEndDate, this.i18n.humanizeDuration(Duration.between(tripsToAccommodation.getFirst().getStartTime(), tripsToAccommodation.getLast().getEndTime())), this.i18n.humanizeDuration(tripsToAccommodation.stream().map(Trip::getDurationSeconds).reduce(0L, Long::sum).longValue())});
                MemoryBlockText accommodationPreRoll = new MemoryBlockText(null, null, text);
                blockParts.add((MemoryBlockPart)accommodationPreRoll);
            }
            MemoryClusterBlock clusterBlock = this.convertToTripCluster(tripsToAccommodation, "Journey to " + ((ProcessedVisit)accommodation.get()).getPlace().getCity());
            blockParts.add((MemoryBlockPart)clusterBlock);
        }
        Map imagesByDay = this.loadImagesFromIntegrations(user, startDate, endDate);
        accommodation.ifPresent(a -> {
            MemoryBlockText intro = new MemoryBlockText(null, this.i18n.translate("memory.generator.intro_accommodation.headline", new Object[]{a.getPlace().getName()}), this.i18n.translate("memory.generator.intro_accommodation.text"));
            blockParts.add((MemoryBlockPart)intro);
            MemoryClusterBlock clusterBlock = new MemoryClusterBlock(null, List.of(a.getId()), null, null, BlockType.CLUSTER_VISIT);
            blockParts.add((MemoryBlockPart)clusterBlock);
            LocalDate dayOfAccommodation = a.getStartTime().atZone(ZoneId.of("UTC")).toLocalDate();
            List images = (List)imagesByDay.get(dayOfAccommodation);
            if (images != null && !images.isEmpty()) {
                MemoryBlockImageGallery imageGallery = new MemoryBlockImageGallery(null, this.fetchImagesFromImmich(user, memory, images));
                blockParts.add((MemoryBlockPart)imageGallery);
                imagesByDay.remove(dayOfAccommodation);
            }
        });
        HashSet<LocalDate> handledDays = new HashSet<LocalDate>();
        ProcessedVisit previousVisit = accommodation.orElse(null);
        for (int i = 0; i < clusters.size(); ++i) {
            MemoryClusterBlock clusterBlock;
            boolean firstOfDay;
            VisitCluster cluster = (VisitCluster)clusters.get(i);
            LocalDate today = cluster.getStartTime().atZone(ZoneId.systemDefault()).toLocalDate();
            if (firstAccommodationArrival != null && cluster.getEndTime() != null && cluster.getEndTime().isBefore(firstAccommodationArrival) || lastAccommodationDeparture != null && cluster.getStartTime() != null && cluster.getStartTime().isAfter(lastAccommodationDeparture)) continue;
            if (!handledDays.contains(today)) {
                blockParts.add((MemoryBlockPart)new MemoryBlockText(null, this.i18n.translate("memory.generator.day.text", new Object[]{Duration.between(startDate.truncatedTo(ChronoUnit.DAYS), cluster.getStartTime().truncatedTo(ChronoUnit.DAYS)).toDays(), cluster.getHighestScoredVisit().visit.getPlace().getCity()}), null));
                handledDays.add(today);
                firstOfDay = true;
            } else {
                firstOfDay = false;
            }
            if (previousVisit != null) {
                ProcessedVisit finalPreviousVisit = previousVisit;
                List<Trip> tripsBetweenVisits = allTripsInRange.stream().filter(trip -> trip.getStartTime() != null && (trip.getStartTime().equals(finalPreviousVisit.getEndTime()) || trip.getStartTime().isAfter(finalPreviousVisit.getEndTime()))).filter(trip -> trip.getEndTime() != null && trip.getEndTime().equals(cluster.getStartTime())).sorted(Comparator.comparing(Trip::getEndTime)).toList();
                if (!tripsBetweenVisits.isEmpty() && cluster.getHighestScoredVisit() != null && Duration.between(tripsBetweenVisits.getFirst().getStartTime(), tripsBetweenVisits.getLast().getEndTime()).toMinutes() > 30L) {
                    clusterBlock = this.convertToTripCluster(tripsBetweenVisits, this.i18n.translate("memory.generator.journey_to.headline.text", new Object[]{cluster.getHighestScoredVisit().visit().getPlace().getCity()}));
                    blockParts.add((MemoryBlockPart)clusterBlock);
                }
                previousVisit = cluster.getVisits().stream().map(ScoredVisit::visit).max(Comparator.comparing(ProcessedVisit::getEndTime)).orElse(null);
            }
            String clusterHeadline = firstOfDay ? null : this.generateClusterHeadline(cluster, i + 1);
            MemoryBlockText clusterTextBlock = new MemoryBlockText(null, clusterHeadline, null);
            blockParts.add((MemoryBlockPart)clusterTextBlock);
            clusterBlock = new MemoryClusterBlock(null, cluster.getVisits().stream().map(ScoredVisit::visit).map(ProcessedVisit::getId).toList(), null, null, BlockType.CLUSTER_VISIT);
            blockParts.add((MemoryBlockPart)clusterBlock);
            List todaysImages = imagesByDay.getOrDefault(today, Collections.emptyList());
            if (!todaysImages.isEmpty()) {
                MemoryBlockImageGallery imageGallery = new MemoryBlockImageGallery(null, this.fetchImagesFromImmich(user, memory, todaysImages));
                blockParts.add((MemoryBlockPart)imageGallery);
            }
            imagesByDay.remove(today);
        }
        if (lastAccommodationDeparture != null) {
            List<Trip> tripsFromAccommodation = allTripsInRange.stream().filter(trip -> trip.getStartTime() != null && !trip.getStartTime().isBefore(lastAccommodationDeparture)).filter(trip -> trip.getEndTime() != null && !trip.getEndTime().isAfter(endDate)).sorted(Comparator.comparing(Trip::getStartTime)).toList();
            if (!tripsFromAccommodation.isEmpty()) {
                String formattedStartDate = MemoryBlockGenerationService.formatTime((Instant)tripsFromAccommodation.getFirst().getStartTime(), (ZoneId)timeZone);
                String formattedEndDate = MemoryBlockGenerationService.formatTime((Instant)tripsFromAccommodation.getLast().getEndTime(), (ZoneId)timeZone);
                String text = this.i18n.translate("memory.generator.travel_from_accommodation.text", new Object[]{accommodation.map(a -> a.getPlace().getCity()).orElse(""), formattedStartDate, homeAfter.map(h -> h.getPlace().getCity()).orElse(""), formattedEndDate, this.i18n.humanizeDuration(Duration.between(tripsFromAccommodation.getFirst().getStartTime(), tripsFromAccommodation.getLast().getEndTime())), this.i18n.humanizeDuration(tripsFromAccommodation.stream().map(Trip::getDurationSeconds).reduce(0L, Long::sum).longValue())});
                MemoryBlockText accommodationPreRoll = new MemoryBlockText(null, null, text);
                blockParts.add((MemoryBlockPart)accommodationPreRoll);
            }
            if (homeAfter.isPresent()) {
                MemoryClusterBlock clusterBlock = this.convertToTripCluster(tripsFromAccommodation, "Journey to " + ((ProcessedVisit)homeAfter.get()).getPlace().getCity());
                blockParts.add((MemoryBlockPart)clusterBlock);
            }
        }
        log.info("Generated {} memory block parts", (Object)blockParts.size());
        return blockParts;
    }

    private List<MemoryBlockImageGallery.GalleryImage> fetchImagesFromImmich(User user, Memory memory, List<PhotoResponse> todaysImages) {
        return todaysImages.stream().map(s -> {
            if (this.storageService.exists("memories/" + memory.getId() + "/" + String.valueOf(s) + "**")) {
                return new MemoryBlockImageGallery.GalleryImage("/api/v1/photos/reitti/memories/" + memory.getId() + "/" + s.getFileName(), null, "immich", s.getId());
            }
            String filename = this.immichIntegrationService.downloadImage(user, s.getId(), "memories/" + memory.getId());
            String imageUrl = "/api/v1/photos/reitti/memories/" + memory.getId() + "/" + filename;
            return new MemoryBlockImageGallery.GalleryImage(imageUrl, null, "immich", s.getId());
        }).toList();
    }

    private Map<LocalDate, List<PhotoResponse>> loadImagesFromIntegrations(User user, Instant startDate, Instant endDate) {
        HashMap<LocalDate, List<PhotoResponse>> map = new HashMap<LocalDate, List<PhotoResponse>>();
        LocalDate currentStart = startDate.atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate currentEnd = startDate.plus(1L, ChronoUnit.DAYS).atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate end = endDate.atZone(ZoneId.of("UTC")).toLocalDate();
        while (!currentEnd.isAfter(end)) {
            map.put(currentStart, this.immichIntegrationService.searchPhotosForRange(user, currentStart, currentStart, "UTC").stream().sorted(Comparator.comparing(PhotoResponse::getDateTime)).toList());
            currentStart = currentEnd;
            currentEnd = currentEnd.plusDays(1L);
        }
        return map;
    }

    private MemoryClusterBlock convertToTripCluster(List<Trip> trips, String title) {
        return new MemoryClusterBlock(null, trips.stream().map(Trip::getId).toList(), title, null, BlockType.CLUSTER_TRIP);
    }

    private String generateIntroductionText(Memory memory, List<VisitCluster> clusters, ProcessedVisit accommodation, ProcessedVisit homePlace, Instant startDate, Instant endDate, ZoneId timeZone) {
        long totalDays = Duration.between(memory.getStartDate(), memory.getEndDate()).toDays() + 1L;
        int totalVisits = clusters.stream().mapToInt(c -> c.getVisits().size()).sum();
        SignificantPlace accommodationPlace = accommodation.getPlace();
        String country = accommodationPlace.getCountryCode() != null ? this.i18n.translateWithDefault("country." + accommodationPlace.getCountryCode() + ".label", accommodation.getPlace().getCountryCode().toLowerCase()) : this.i18n.translate("country.unknown.label");
        String formattedStartDate = MemoryBlockGenerationService.formatDate((Instant)startDate, (ZoneId)timeZone, (boolean)true);
        String formattedEndDate = MemoryBlockGenerationService.formatDate((Instant)endDate, (ZoneId)timeZone, (boolean)false);
        return this.i18n.translate("memory.generator.introductory.text", new Object[]{formattedStartDate, homePlace.getPlace().getCity(), totalDays, accommodationPlace.getCity(), country, totalVisits, clusters.size(), formattedEndDate});
    }

    private static String formatDate(Instant date, ZoneId timeZone, boolean withYear) {
        LocalDate localEnd = date.atZone(timeZone).toLocalDate();
        return withYear ? localEnd.format(FULL_DATE_FORMATTER.withLocale(LocaleContextHolder.getLocale())) : localEnd.format(DATE_FORMATTER.withLocale(LocaleContextHolder.getLocale()));
    }

    private static String formatTime(Instant date, ZoneId timeZone) {
        LocalDateTime localEnd = date.atZone(timeZone).toLocalDateTime();
        return localEnd.format(TIME_FORMATTER.withLocale(LocaleContextHolder.getLocale()));
    }

    private String generateClusterHeadline(VisitCluster cluster, int clusterNumber) {
        ScoredVisit topVisit = cluster.getHighestScoredVisit();
        if (topVisit != null && topVisit.visit().getPlace().getName() != null) {
            return topVisit.visit().getPlace().getName();
        }
        return "Location " + clusterNumber;
    }

    private List<ProcessedVisit> filterVisits(List<ProcessedVisit> visits, ProcessedVisit accommodation) {
        Long accommodationPlaceId = accommodation != null ? accommodation.getPlace().getId() : null;
        return visits.stream().filter(visit -> {
            if (visit.getPlace().getId().equals(accommodationPlaceId)) {
                return false;
            }
            return visit.getDurationSeconds() >= 600L;
        }).collect(Collectors.toList());
    }

    private List<ScoredVisit> scoreVisits(List<ProcessedVisit> visits, ProcessedVisit accommodation) {
        Map<Long, Long> visitCounts = visits.stream().collect(Collectors.groupingBy(v -> v.getPlace().getId(), Collectors.counting()));
        long maxDuration = visits.stream().mapToLong(ProcessedVisit::getDurationSeconds).max().orElse(1L);
        return visits.stream().map(visit -> {
            double score = 0.0;
            double durationScore = (double)visit.getDurationSeconds().longValue() / (double)maxDuration;
            score += 1.0 * durationScore;
            if (accommodation != null) {
                double distance = GeoUtils.distanceInMeters((double)visit.getPlace().getLatitudeCentroid(), (double)visit.getPlace().getLongitudeCentroid(), (double)accommodation.getPlace().getLatitudeCentroid(), (double)accommodation.getPlace().getLongitudeCentroid());
                double distanceScore = Math.min(distance / 50000.0, 1.0);
                score += 2.0 * distanceScore;
            }
            double categoryScore = this.getCategoryWeight(visit.getPlace().getType());
            score += 3.0 * categoryScore;
            long visitCount = (Long)visitCounts.get(visit.getPlace().getId());
            double noveltyScore = 1.0 / (double)visitCount;
            return new ScoredVisit(visit, score += 1.5 * noveltyScore);
        }).collect(Collectors.toList());
    }

    private double getCategoryWeight(SignificantPlace.PlaceType placeType) {
        if (placeType == null) {
            return 0.3;
        }
        return switch (1.$SwitchMap$com$dedicatedcode$reitti$model$geo$SignificantPlace$PlaceType[placeType.ordinal()]) {
            case 1, 2, 3, 4, 5, 6 -> 1.0;
            case 7, 8, 9, 10, 11, 12, 13 -> 0.6;
            case 14, 15, 16, 17, 18 -> 0.2;
            default -> 0.4;
        };
    }

    private List<VisitCluster> clusterVisits(List<ScoredVisit> scoredVisits) {
        if (scoredVisits.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ScoredVisit> sortedVisits = new ArrayList<ScoredVisit>(scoredVisits);
        sortedVisits.sort(Comparator.comparing(sv -> sv.visit().getStartTime()));
        ArrayList<VisitCluster> clusters = new ArrayList<VisitCluster>();
        VisitCluster currentCluster = new VisitCluster();
        currentCluster.addVisit((ScoredVisit)sortedVisits.getFirst());
        for (int i = 1; i < sortedVisits.size(); ++i) {
            ScoredVisit current = (ScoredVisit)sortedVisits.get(i);
            ScoredVisit previous = (ScoredVisit)sortedVisits.get(i - 1);
            long timeDiff = Duration.between(previous.visit().getEndTime(), current.visit().getStartTime()).getSeconds();
            double distance = GeoUtils.distanceInMeters((double)previous.visit().getPlace().getLatitudeCentroid(), (double)previous.visit().getPlace().getLongitudeCentroid(), (double)current.visit().getPlace().getLatitudeCentroid(), (double)current.visit().getPlace().getLongitudeCentroid());
            if (timeDiff <= 7200L && distance <= 1000.0) {
                currentCluster.addVisit(current);
                continue;
            }
            clusters.add(currentCluster);
            currentCluster = new VisitCluster();
            currentCluster.addVisit(current);
        }
        if (!currentCluster.getVisits().isEmpty()) {
            clusters.add(currentCluster);
        }
        return clusters;
    }
}

