/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.controller.error.PageNotFoundException;
import com.dedicatedcode.reitti.model.TimeDisplayMode;
import com.dedicatedcode.reitti.model.geo.ProcessedVisit;
import com.dedicatedcode.reitti.model.geo.Trip;
import com.dedicatedcode.reitti.model.memory.BlockType;
import com.dedicatedcode.reitti.model.memory.Memory;
import com.dedicatedcode.reitti.model.memory.MemoryBlock;
import com.dedicatedcode.reitti.model.memory.MemoryBlockImageGallery;
import com.dedicatedcode.reitti.model.memory.MemoryBlockPart;
import com.dedicatedcode.reitti.model.memory.MemoryBlockText;
import com.dedicatedcode.reitti.model.memory.MemoryClusterBlock;
import com.dedicatedcode.reitti.model.memory.MemoryTrip;
import com.dedicatedcode.reitti.model.memory.MemoryTripClusterBlockDTO;
import com.dedicatedcode.reitti.model.memory.MemoryVisit;
import com.dedicatedcode.reitti.model.memory.MemoryVisitClusterBlockDTO;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSettings;
import com.dedicatedcode.reitti.repository.MemoryBlockImageGalleryJdbcService;
import com.dedicatedcode.reitti.repository.MemoryBlockJdbcService;
import com.dedicatedcode.reitti.repository.MemoryBlockTextJdbcService;
import com.dedicatedcode.reitti.repository.MemoryClusterBlockRepository;
import com.dedicatedcode.reitti.repository.MemoryJdbcService;
import com.dedicatedcode.reitti.repository.MemoryTripJdbcService;
import com.dedicatedcode.reitti.repository.MemoryVisitJdbcService;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import com.dedicatedcode.reitti.service.MemoryBlockGenerationService;
import com.dedicatedcode.reitti.service.MemoryService;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MemoryService {
    private static final Logger log = LoggerFactory.getLogger(MemoryService.class);
    private final MemoryJdbcService memoryJdbcService;
    private final MemoryBlockJdbcService memoryBlockJdbcService;
    private final MemoryBlockTextJdbcService memoryBlockTextJdbcService;
    private final MemoryBlockImageGalleryJdbcService memoryBlockImageGalleryJdbcService;
    private final MemoryClusterBlockRepository memoryClusterBlockRepository;
    private final MemoryBlockGenerationService blockGenerationService;
    private final MemoryVisitJdbcService memoryVisitJdbcService;
    private final MemoryTripJdbcService memoryTripJdbcService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final TripJdbcService tripJdbcService;
    private final ProcessedVisitJdbcService processedVisitJdbcService;

    public MemoryService(MemoryJdbcService memoryJdbcService, MemoryBlockJdbcService memoryBlockJdbcService, MemoryBlockTextJdbcService memoryBlockTextJdbcService, MemoryBlockImageGalleryJdbcService memoryBlockImageGalleryJdbcService, MemoryClusterBlockRepository memoryClusterBlockRepository, MemoryBlockGenerationService blockGenerationService, MemoryVisitJdbcService memoryVisitJdbcService, MemoryTripJdbcService memoryTripJdbcService, UserSettingsJdbcService userSettingsJdbcService, TripJdbcService tripJdbcService, ProcessedVisitJdbcService processedVisitJdbcService) {
        this.memoryJdbcService = memoryJdbcService;
        this.memoryBlockJdbcService = memoryBlockJdbcService;
        this.memoryBlockTextJdbcService = memoryBlockTextJdbcService;
        this.memoryBlockImageGalleryJdbcService = memoryBlockImageGalleryJdbcService;
        this.memoryClusterBlockRepository = memoryClusterBlockRepository;
        this.blockGenerationService = blockGenerationService;
        this.memoryVisitJdbcService = memoryVisitJdbcService;
        this.memoryTripJdbcService = memoryTripJdbcService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.tripJdbcService = tripJdbcService;
        this.processedVisitJdbcService = processedVisitJdbcService;
    }

    @Transactional
    public Memory createMemory(User user, Memory memory) {
        return this.memoryJdbcService.create(user, memory);
    }

    @Transactional
    public Memory updateMemory(User user, Memory memory) {
        return this.memoryJdbcService.update(user, memory);
    }

    @Transactional
    public void deleteMemory(User user, Long memoryId) {
        this.memoryJdbcService.delete(user, memoryId);
    }

    public Optional<Memory> getMemoryById(User user, Long id) {
        return this.memoryJdbcService.findById(user, id);
    }

    public List<Memory> getMemoriesForUser(User user, String sortBy, String sortOrder) {
        return this.memoryJdbcService.findAllByUser(user, sortBy, sortOrder);
    }

    public List<Memory> getMemoriesForUserAndYear(User user, int year, String sortBy, String sortOrder) {
        return this.memoryJdbcService.findAllByUserAndYear(user, year, sortBy, sortOrder);
    }

    @Transactional
    public MemoryBlock addBlock(User user, Long memoryId, int position, BlockType blockType) {
        this.memoryJdbcService.findById(user, memoryId).orElseThrow(() -> new PageNotFoundException("Unable to find memory with id [" + memoryId + "]"));
        int maxPosition = this.memoryBlockJdbcService.getMaxPosition(memoryId);
        MemoryBlock block = new MemoryBlock(memoryId, blockType, Integer.valueOf(maxPosition + 1));
        block = this.memoryBlockJdbcService.create(block);
        if (position > -1) {
            List list = this.memoryBlockJdbcService.findByMemoryId(memoryId);
            MemoryBlock lastBlock = (MemoryBlock)list.removeLast();
            list.add(position, lastBlock);
            this.reorderBlocks(user, memoryId, list.stream().map(MemoryBlock::getId).toList());
        }
        return block;
    }

    @Transactional
    public void deleteBlock(Long blockId) {
        this.memoryBlockJdbcService.delete(blockId);
    }

    public List<MemoryBlockPart> getBlockPartsForMemory(User user, Long memoryId, ZoneId timezone) {
        UserSettings settings = this.userSettingsJdbcService.getOrCreateDefaultSettings(user.getId());
        List blocks = this.memoryBlockJdbcService.findByMemoryId(memoryId);
        ArrayList<MemoryBlockPart> blockParts = new ArrayList<MemoryBlockPart>();
        for (MemoryBlock block : blocks) {
            Optional part = this.loadAndConvertBlockInstance(user, timezone, block, settings);
            part.ifPresent(blockParts::add);
        }
        return blockParts;
    }

    public Optional<? extends MemoryBlockPart> getBlock(User user, ZoneId timezone, long memoryId, long blockId) {
        UserSettings settings = this.userSettingsJdbcService.getOrCreateDefaultSettings(user.getId());
        Optional blockOpt = this.memoryBlockJdbcService.findById(user, Long.valueOf(blockId));
        if (blockOpt.isPresent()) {
            MemoryBlock block = (MemoryBlock)blockOpt.get();
            if (!block.getMemoryId().equals(memoryId)) {
                throw new IllegalArgumentException("Block does not belong to this memory");
            }
            return this.loadAndConvertBlockInstance(user, timezone, block, settings);
        }
        return Optional.empty();
    }

    private Optional<? extends MemoryBlockPart> loadAndConvertBlockInstance(User user, ZoneId timezone, MemoryBlock block, UserSettings settings) {
        return switch (1.$SwitchMap$com$dedicatedcode$reitti$model$memory$BlockType[block.getBlockType().ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> this.memoryBlockTextJdbcService.findByBlockId(block.getId());
            case 2 -> this.memoryBlockImageGalleryJdbcService.findByBlockId(block.getId());
            case 3 -> this.getClusterTripBlock(user, timezone, block, settings);
            case 4 -> this.getClusterVisitBlock(user, timezone, block, settings);
        };
    }

    public Optional<MemoryBlock> getBlockById(User user, Long blockId) {
        return this.memoryBlockJdbcService.findById(user, blockId);
    }

    public Optional<MemoryClusterBlock> getClusterBlock(User user, Long blockId) {
        return this.memoryClusterBlockRepository.findByBlockId(user, blockId);
    }

    @Transactional
    public MemoryBlockText addTextBlock(Long blockId, String headline, String content) {
        MemoryBlockText blockText = new MemoryBlockText(blockId, headline, content);
        return this.memoryBlockTextJdbcService.create(blockText);
    }

    @Transactional
    public MemoryBlockText updateTextBlock(User user, MemoryBlockText blockText) {
        return this.memoryBlockTextJdbcService.update(blockText);
    }

    @Transactional
    public MemoryBlockImageGallery updateImageBlock(User user, MemoryBlockImageGallery blockText) {
        return this.memoryBlockImageGalleryJdbcService.update(blockText);
    }

    @Transactional
    public MemoryClusterBlock createClusterBlock(User user, Memory memory, String title, int position, BlockType type, List<Long> selectedParts) {
        MemoryBlock block = this.addBlock(user, memory.getId(), position, type);
        ArrayList selectedPartIds = new ArrayList();
        switch (1.$SwitchMap$com$dedicatedcode$reitti$model$memory$BlockType[type.ordinal()]) {
            case 3: {
                for (Long partId : selectedParts) {
                    this.tripJdbcService.findById(partId).map(trip -> {
                        MemoryVisit startVisit = this.memoryVisitJdbcService.save(user, MemoryVisit.create((ProcessedVisit)trip.getStartVisit()), block.getId(), trip.getStartVisit().getId());
                        MemoryVisit endVisit = this.memoryVisitJdbcService.save(user, MemoryVisit.create((ProcessedVisit)trip.getEndVisit()), block.getId(), trip.getEndVisit().getId());
                        MemoryTrip memoryTrip = MemoryTrip.create((Trip)trip, (MemoryVisit)startVisit, (MemoryVisit)endVisit);
                        return this.memoryTripJdbcService.save(user, memoryTrip, block.getId(), trip.getId());
                    }).map(MemoryTrip::getId).ifPresent(selectedPartIds::add);
                }
                break;
            }
            case 4: {
                for (Long partId : selectedParts) {
                    this.processedVisitJdbcService.findById(partId).map(visit -> {
                        MemoryVisit memoryVisit = MemoryVisit.create((ProcessedVisit)visit);
                        return this.memoryVisitJdbcService.save(user, memoryVisit, block.getId(), visit.getId());
                    }).map(MemoryVisit::getId).ifPresent(selectedPartIds::add);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid block type");
            }
        }
        MemoryClusterBlock clusterBlock = new MemoryClusterBlock(block.getId(), selectedPartIds, title, null, type);
        return this.memoryClusterBlockRepository.save(user, clusterBlock);
    }

    @Transactional
    public MemoryClusterBlock updateClusterBlock(User user, MemoryClusterBlock clusterBlock) {
        return this.memoryClusterBlockRepository.update(user, clusterBlock);
    }

    public Optional<MemoryBlockText> getTextBlock(Long blockId) {
        return this.memoryBlockTextJdbcService.findByBlockId(blockId);
    }

    @Transactional
    public MemoryBlockImageGallery addImageGalleryBlock(Long blockId, List<MemoryBlockImageGallery.GalleryImage> images) {
        return this.memoryBlockImageGalleryJdbcService.create(new MemoryBlockImageGallery(blockId, images));
    }

    @Transactional
    public void deleteImageFromGallery(Long imageId) {
        this.memoryBlockImageGalleryJdbcService.delete(imageId);
    }

    public MemoryBlockImageGallery getImagesForBlock(Long blockId) {
        return (MemoryBlockImageGallery)this.memoryBlockImageGalleryJdbcService.findByBlockId(blockId).orElseThrow(() -> new IllegalArgumentException("Block not found"));
    }

    @Transactional
    public void reorderBlocks(User user, Long memoryId, List<Long> blockIds) {
        List allBlocks = this.memoryBlockJdbcService.findByMemoryId(memoryId);
        int offset = blockIds.size() + 2;
        for (MemoryBlock block : allBlocks) {
            this.memoryBlockJdbcService.update(block.withPosition(Integer.valueOf(block.getPosition() + offset)));
        }
        for (int i = 0; i < blockIds.size(); ++i) {
            Long blockId = blockIds.get(i);
            Optional blockOpt = this.memoryBlockJdbcService.findById(user, blockId);
            if (!blockOpt.isPresent()) continue;
            MemoryBlock block = (MemoryBlock)blockOpt.get();
            if (!block.getMemoryId().equals(memoryId)) {
                throw new IllegalArgumentException("Block does not belong to this memory");
            }
            if (block.getPosition().equals(i)) continue;
            this.memoryBlockJdbcService.update(block.withPosition(Integer.valueOf(i)));
        }
    }

    @Transactional
    public void recalculateMemory(User user, Long memoryId, ZoneId timezone) {
        Memory memory = (Memory)this.memoryJdbcService.findById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        this.memoryBlockJdbcService.deleteByMemoryId(memoryId);
        List autoGeneratedBlocks = this.blockGenerationService.generate(user, memory, timezone);
        for (MemoryBlockPart autoGeneratedBlock : autoGeneratedBlocks) {
            MemoryBlock memoryBlock;
            if (autoGeneratedBlock instanceof MemoryBlockText) {
                MemoryBlockText textBlock = (MemoryBlockText)autoGeneratedBlock;
                memoryBlock = this.addBlock(user, memoryId, -1, BlockType.TEXT);
                this.memoryBlockTextJdbcService.create(new MemoryBlockText(memoryBlock.getId(), textBlock.getHeadline(), textBlock.getContent()));
                continue;
            }
            if (autoGeneratedBlock instanceof MemoryBlockImageGallery) {
                MemoryBlockImageGallery imageGalleryBlock = (MemoryBlockImageGallery)autoGeneratedBlock;
                memoryBlock = this.addBlock(user, memoryId, -1, BlockType.IMAGE_GALLERY);
                this.memoryBlockImageGalleryJdbcService.create(new MemoryBlockImageGallery(memoryBlock.getId(), imageGalleryBlock.getImages()));
                continue;
            }
            if (!(autoGeneratedBlock instanceof MemoryClusterBlock)) continue;
            MemoryClusterBlock clusterBlock = (MemoryClusterBlock)autoGeneratedBlock;
            this.createClusterBlock(user, memory, clusterBlock.getTitle(), -1, clusterBlock.getType(), clusterBlock.getPartIds());
        }
        log.info("Recalculated memory {} with {} blocks", (Object)memoryId, (Object)autoGeneratedBlocks.size());
    }

    private Optional<? extends MemoryBlockPart> getClusterTripBlock(User user, ZoneId timezone, MemoryBlock block, UserSettings settings) {
        Optional clusterBlockOpt = this.memoryClusterBlockRepository.findByBlockId(user, block.getId());
        return clusterBlockOpt.map(memoryClusterBlock -> {
            List trips = this.memoryTripJdbcService.findByMemoryBlockId(memoryClusterBlock.getBlockId());
            Optional first = trips.stream().findFirst();
            Optional<MemoryTrip> lastTrip = trips.stream().max(Comparator.comparing(MemoryTrip::getEndTime));
            if (first.isEmpty()) {
                return null;
            }
            long movingTime = trips.stream().mapToLong(MemoryTrip::getDurationSeconds).sum();
            long completeTime = first.map(trip -> Duration.between(trip.getStartTime(), ((MemoryTrip)lastTrip.get()).getEndTime()).toSeconds()).orElse(0L);
            LocalDateTime adjustedStartTime = first.map(t -> this.adjustTime(settings, t.getStartTime(), t.getStartVisit().getTimezone(), timezone)).orElse(null);
            LocalDateTime adjustedEndTime = lastTrip.map(t -> this.adjustTime(settings, t.getEndTime(), t.getEndVisit().getTimezone(), timezone)).orElse(null);
            return new MemoryTripClusterBlockDTO(memoryClusterBlock, trips, "/api/v1/raw-location-points?startDate=" + String.valueOf(adjustedStartTime) + "&endDate=" + String.valueOf(adjustedEndTime) + "&timezone=" + timezone.getId(), adjustedStartTime, adjustedEndTime, Long.valueOf(completeTime), Long.valueOf(movingTime));
        });
    }

    private Optional<? extends MemoryBlockPart> getClusterVisitBlock(User user, ZoneId timezone, MemoryBlock block, UserSettings settings) {
        Optional clusterVisitBlockOpt = this.memoryClusterBlockRepository.findByBlockId(user, block.getId());
        Optional<MemoryVisitClusterBlockDTO> part = clusterVisitBlockOpt.map(memoryClusterBlock -> {
            List visits = this.memoryVisitJdbcService.findByMemoryBlockId(block.getId());
            Optional first = visits.stream().findFirst();
            Optional<MemoryVisit> last = visits.stream().max(Comparator.comparing(MemoryVisit::getEndTime));
            LocalDateTime adjustedStartTime = first.map(t -> this.adjustTime(settings, t.getStartTime(), t.getTimezone(), timezone)).orElse(null);
            LocalDateTime adjustedEndTime = last.map(t -> this.adjustTime(settings, t.getEndTime(), t.getTimezone(), timezone)).orElse(null);
            Long completeDuration = 0L;
            String rawLocationPointsUrl = first.map(processedVisit -> "/api/v1/raw-location-points?startDate=" + String.valueOf(processedVisit.getStartTime().atZone(timezone).toLocalDateTime()) + "&endDate=" + String.valueOf(((MemoryVisit)last.get()).getEndTime().atZone(timezone).toLocalDateTime()) + "&timezone=" + String.valueOf(timezone)).orElse(null);
            return new MemoryVisitClusterBlockDTO(memoryClusterBlock, visits, rawLocationPointsUrl, adjustedStartTime, adjustedEndTime, completeDuration);
        });
        return part;
    }

    private LocalDateTime adjustTime(UserSettings settings, Instant startTime, ZoneId placeTimezone, ZoneId timezone) {
        if (settings.getTimeDisplayMode() == TimeDisplayMode.DEFAULT) {
            return startTime.atZone(timezone).toLocalDateTime();
        }
        return startTime.atZone(placeTimezone).toLocalDateTime();
    }

    public List<Integer> getAvailableYears(User user) {
        return this.memoryJdbcService.findDistinctYears(user);
    }

    public long getOwnerId(Memory memory) {
        return (Long)this.memoryJdbcService.getOwnerId(memory).orElseThrow(() -> new PageNotFoundException("Memory not found"));
    }
}

