/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.event.SSEEvent;
import com.dedicatedcode.reitti.event.SignificantPlaceCreatedEvent;
import com.dedicatedcode.reitti.event.TriggerProcessingEvent;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.service.UserSseEmitterService;
import com.dedicatedcode.reitti.service.VisitDetectionPreviewService;
import com.dedicatedcode.reitti.service.geocoding.ReverseGeocodingListener;
import com.dedicatedcode.reitti.service.processing.ProcessingPipelineTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageDispatcherService {
    private static final Logger logger = LoggerFactory.getLogger(MessageDispatcherService.class);
    private final ReverseGeocodingListener reverseGeocodingListener;
    private final ProcessingPipelineTrigger processingPipelineTrigger;
    private final UserSseEmitterService userSseEmitterService;
    private final UserJdbcService userJdbcService;
    private final VisitDetectionPreviewService visitDetectionPreviewService;

    @Autowired
    public MessageDispatcherService(ReverseGeocodingListener reverseGeocodingListener, ProcessingPipelineTrigger processingPipelineTrigger, UserSseEmitterService userSseEmitterService, UserJdbcService userJdbcService, VisitDetectionPreviewService visitDetectionPreviewService) {
        this.reverseGeocodingListener = reverseGeocodingListener;
        this.processingPipelineTrigger = processingPipelineTrigger;
        this.userSseEmitterService = userSseEmitterService;
        this.userJdbcService = userJdbcService;
        this.visitDetectionPreviewService = visitDetectionPreviewService;
    }

    @RabbitListener(queues={"reitti.place.created.v2"}, concurrency="${reitti.events.concurrency}")
    public void handleSignificantPlaceCreated(SignificantPlaceCreatedEvent event) {
        logger.info("Dispatching SignificantPlaceCreatedEvent: {}", (Object)event);
        this.reverseGeocodingListener.handleSignificantPlaceCreated(event);
        this.visitDetectionPreviewService.updatePreviewStatus(event.previewId());
    }

    @RabbitListener(queues={"reitti.user.events.v2"})
    public void handleUserNotificationEvent(SSEEvent event) {
        logger.trace("Dispatching SSEEvent: {}", (Object)event);
        this.userJdbcService.findById(event.getUserId()).ifPresentOrElse(user -> this.userSseEmitterService.sendEventToUser(user, event), () -> logger.warn("User not found for user: {}", (Object)event.getUserId()));
    }

    @RabbitListener(queues={"reitti.processing.v2"}, concurrency="${reitti.events.concurrency}")
    public void handleTriggerProcessingEvent(TriggerProcessingEvent event) {
        logger.info("Dispatching TriggerProcessingEvent {}", (Object)event);
        this.processingPipelineTrigger.handle(event, false);
        this.visitDetectionPreviewService.updatePreviewStatus(event.getPreviewId());
    }
}

