/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.model.geo.GeoPoint;
import com.dedicatedcode.reitti.model.geo.GeoUtils;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.SignificantPlaceJdbcService;
import com.dedicatedcode.reitti.service.I18nService;
import com.dedicatedcode.reitti.service.PlaceChangeDetectionService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PlaceChangeDetectionService {
    private static final Logger log = LoggerFactory.getLogger(PlaceChangeDetectionService.class);
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final SignificantPlaceJdbcService placeJdbcService;
    private final I18nService i18nService;
    private final ObjectMapper objectMapper;

    public PlaceChangeDetectionService(ProcessedVisitJdbcService processedVisitJdbcService, SignificantPlaceJdbcService placeJdbcService, I18nService i18nService, ObjectMapper objectMapper) {
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.placeJdbcService = placeJdbcService;
        this.i18nService = i18nService;
        this.objectMapper = objectMapper;
    }

    public PlaceChangeAnalysis analyzeChanges(User user, Long placeId, String polygonData) {
        try {
            SignificantPlace currentPlace = (SignificantPlace)this.placeJdbcService.findById(placeId).orElseThrow();
            ArrayList warnings = new ArrayList();
            boolean changed = this.analyzePolygonChanges(currentPlace, polygonData, warnings);
            if (changed |= this.analyzeOverlappingPlaces(user, placeId, polygonData, warnings)) {
                this.calculateAffectedDays(user, currentPlace, polygonData, warnings);
            }
            return new PlaceChangeAnalysis(warnings.isEmpty(), warnings);
        }
        catch (Exception e) {
            return new PlaceChangeAnalysis(false, List.of(this.i18nService.translate("places.warning.general_error", new Object[]{e.getMessage()})));
        }
    }

    private void calculateAffectedDays(User user, SignificantPlace currentPlace, String polygonData, List<String> warnings) throws Exception {
        List<SignificantPlace> overlappingPlaces;
        if (polygonData != null) {
            overlappingPlaces = new ArrayList<SignificantPlace>(this.checkForOverlappingPlaces(user, currentPlace.getId(), Collections.emptyList()));
            overlappingPlaces.add(currentPlace);
        } else {
            overlappingPlaces = List.of(currentPlace);
        }
        int affectedDays = this.processedVisitJdbcService.getAffectedDays(overlappingPlaces).size();
        if (affectedDays > 0) {
            warnings.add(this.i18nService.translate("places.warning.overlapping.recalculation_hint", new Object[]{affectedDays}));
        }
    }

    private boolean analyzePolygonChanges(SignificantPlace currentPlace, String polygonData, List<String> warnings) {
        boolean willHavePolygon;
        boolean changed = false;
        boolean hadPolygon = currentPlace.getPolygon() != null && !currentPlace.getPolygon().isEmpty();
        boolean bl = willHavePolygon = polygonData != null && !polygonData.trim().isEmpty();
        if (hadPolygon && !willHavePolygon) {
            warnings.add(this.i18nService.translate("places.warning.polygon.removal"));
            changed = true;
        }
        if (!hadPolygon && willHavePolygon) {
            warnings.add(this.i18nService.translate("places.warning.polygon.addition"));
            changed = true;
        }
        if (hadPolygon && willHavePolygon) {
            try {
                List newPolygon = this.parsePolygonData(polygonData);
                GeoPoint newCentroid = GeoUtils.calculatePolygonCentroid((List)newPolygon);
                GeoPoint currentCentroid = new GeoPoint(currentPlace.getLatitudeCentroid().doubleValue(), currentPlace.getLongitudeCentroid().doubleValue());
                double currentArea = GeoUtils.calculatePolygonArea((List)currentPlace.getPolygon());
                double newArea = GeoUtils.calculatePolygonArea((List)newPolygon);
                double latDiff = Math.abs(newCentroid.latitude() - currentCentroid.latitude());
                double lngDiff = Math.abs(newCentroid.longitude() - currentCentroid.longitude());
                if (latDiff > 1.0E-4 || lngDiff > 1.0E-4 || Math.abs(newArea - currentArea) > 1.0) {
                    warnings.add(this.i18nService.translate("places.warning.polygon.significant_change"));
                    changed = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return changed;
    }

    private boolean analyzeOverlappingPlaces(User user, Long placeId, String polygonData, List<String> warnings) {
        boolean willHavePolygon;
        boolean bl = willHavePolygon = polygonData != null && !polygonData.trim().isEmpty();
        if (willHavePolygon) {
            try {
                List newPolygon = this.parsePolygonData(polygonData);
                int overlappingPlaces = this.checkForOverlappingPlaces(user, placeId, newPolygon).size();
                if (overlappingPlaces > 0) {
                    warnings.add(this.i18nService.translate("places.warning.overlapping.visits", new Object[]{overlappingPlaces}));
                    return true;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to parse polygon data: " + e.getMessage(), e);
            }
        }
        return false;
    }

    private List<GeoPoint> parsePolygonData(String polygonData) throws Exception {
        JsonNode jsonNode = this.objectMapper.readTree(polygonData);
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
        if (jsonNode.isArray()) {
            for (JsonNode pointNode : jsonNode) {
                if (pointNode.has("lat") && pointNode.has("lng")) {
                    double lat = pointNode.get("lat").asDouble();
                    double lng = pointNode.get("lng").asDouble();
                    geoPoints.add(new GeoPoint(lat, lng));
                    continue;
                }
                throw new IllegalArgumentException("Each point must have 'lat' and 'lng' properties");
            }
        } else {
            throw new IllegalArgumentException("Polygon data must be an array of coordinate objects");
        }
        if (geoPoints.size() < 3) {
            throw new IllegalArgumentException("Polygon must have at least 3 points");
        }
        return geoPoints;
    }

    private List<SignificantPlace> checkForOverlappingPlaces(User user, Long placeId, List<GeoPoint> newPolygon) {
        return this.placeJdbcService.findPlacesOverlappingWithPolygon(user.getId(), placeId, newPolygon);
    }
}

