/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.service.I18nService;
import com.dedicatedcode.reitti.service.StatisticsService;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class StatisticsService {
    private final TripJdbcService tripJdbcService;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final I18nService i18nService;

    public StatisticsService(TripJdbcService tripJdbcService, ProcessedVisitJdbcService processedVisitJdbcService, RawLocationPointJdbcService rawLocationPointJdbcService, I18nService i18nService) {
        this.tripJdbcService = tripJdbcService;
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.i18nService = i18nService;
    }

    private TransportStatistic mapTransportStatistics(Object[] row) {
        String transportMode = (String)row[0];
        Double totalDistanceMeters = (Double)row[1];
        Long durationInSeconds = (Long)row[2];
        Long tripCount = (Long)row[3];
        double totalDistanceKm = totalDistanceMeters / 1000.0;
        double totalDurationHours = (double)durationInSeconds.longValue() / 3600.0;
        return new TransportStatistic(transportMode != null ? transportMode : this.i18nService.translate("timeline.transport.UNKNOWN.label"), totalDistanceKm, totalDurationHours, tripCount.intValue());
    }

    public List<Integer> getAvailableYears(User user) {
        return this.rawLocationPointJdbcService.findDistinctYearsByUser(user);
    }

    public List<VisitStatistic> getTopVisitsByStayTime(User user, Instant startTime, Instant endTime, int limit) {
        List results = startTime == null || endTime == null ? this.processedVisitJdbcService.findTopPlacesByStayTimeWithLimit(user, (long)limit) : this.processedVisitJdbcService.findTopPlacesByStayTimeWithLimit(user, startTime, endTime, (long)limit);
        return results.stream().map(row -> {
            String placeName = (String)row[0];
            Long totalDurationSeconds = (Long)row[1];
            Long visitCount = (Long)row[2];
            Double latitude = (Double)row[3];
            Double longitude = (Double)row[4];
            double totalStayTimeHours = (double)totalDurationSeconds.longValue() / 3600.0;
            return new VisitStatistic(placeName != null ? placeName : this.i18nService.translate("places.unknown.label"), totalStayTimeHours, visitCount.intValue(), latitude, longitude);
        }).collect(Collectors.toList());
    }

    public List<TransportStatistic> getTransportStatistics(User user, Instant startTime, Instant endTime) {
        List results = this.tripJdbcService.findTransportStatisticsByUserAndTimeRange(user, startTime, endTime);
        return results.stream().map(arg_0 -> this.mapTransportStatistics(arg_0)).collect(Collectors.toList());
    }

    public List<TransportStatistic> getTransportStatistics(User user) {
        List results = this.tripJdbcService.findTransportStatisticsByUser(user);
        return results.stream().map(arg_0 -> this.mapTransportStatistics(arg_0)).collect(Collectors.toList());
    }

    public List<VisitStatistic> getOverallTopVisits(User user) {
        return this.getTopVisitsByStayTime(user, null, null, 5);
    }

    public List<TransportStatistic> getOverallTransportStatistics(User user) {
        return this.getTransportStatistics(user);
    }

    public List<VisitStatistic> getYearTopVisits(User user, int year) {
        Instant startOfYear = LocalDate.of(year, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant();
        Instant endOfYear = LocalDate.of(year, 12, 31).atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant();
        return this.getTopVisitsByStayTime(user, startOfYear, endOfYear, 5);
    }

    public List<TransportStatistic> getYearTransportStatistics(User user, int year) {
        Instant startOfYear = LocalDate.of(year, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant();
        Instant endOfYear = LocalDate.of(year, 12, 31).atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant();
        return this.getTransportStatistics(user, startOfYear, endOfYear);
    }

    public List<MonthlyTransportData> getMonthlyTransportBreakdown(User user, int year) {
        ArrayList<MonthlyTransportData> monthlyData = new ArrayList<MonthlyTransportData>();
        for (int month = 1; month <= 12; ++month) {
            Instant startOfMonth = LocalDate.of(year, month, 1).atStartOfDay(ZoneId.systemDefault()).toInstant();
            Instant endOfMonth = LocalDate.of(year, month, 1).plusMonths(1L).minusDays(1L).atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant();
            List monthStats = this.getTransportStatistics(user, startOfMonth, endOfMonth);
            monthlyData.add(new MonthlyTransportData(Month.of(month).name(), monthStats));
        }
        return monthlyData;
    }

    public List<DailyTransportData> getDailyTransportBreakdown(User user, int year, int month) {
        ArrayList<DailyTransportData> dailyData = new ArrayList<DailyTransportData>();
        LocalDate startDate = LocalDate.of(year, month, 1);
        LocalDate endDate = startDate.plusMonths(1L).minusDays(1L);
        LocalDate date = startDate;
        while (!date.isAfter(endDate)) {
            Instant startOfDay = date.atStartOfDay(ZoneId.systemDefault()).toInstant();
            Instant endOfDay = date.atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant();
            List dayStats = this.getTransportStatistics(user, startOfDay, endOfDay);
            dailyData.add(new DailyTransportData(date.getDayOfMonth(), dayStats));
            date = date.plusDays(1L);
        }
        return dailyData;
    }

    public List<VisitStatistic> getMonthTopVisits(User user, int year, int month) {
        Instant startOfMonth = LocalDate.of(year, month, 1).atStartOfDay(ZoneId.systemDefault()).toInstant();
        Instant endOfMonth = LocalDate.of(year, month, 1).plusMonths(1L).minusDays(1L).atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant();
        return this.getTopVisitsByStayTime(user, startOfMonth, endOfMonth, 5);
    }

    public List<TransportStatistic> getMonthTransportStatistics(User user, int year, int month) {
        Instant startOfMonth = LocalDate.of(year, month, 1).atStartOfDay(ZoneId.systemDefault()).toInstant();
        Instant endOfMonth = LocalDate.of(year, month, 1).plusMonths(1L).minusDays(1L).atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant();
        return this.getTransportStatistics(user, startOfMonth, endOfMonth);
    }
}

