/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.service.StorageService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StorageService {
    private final String storagePath;

    public StorageService(@Value(value="${reitti.storage.path}") String storagePath) {
        this.storagePath = storagePath;
        Path path = Paths.get(storagePath, new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create storage directory '" + storagePath + "': " + e.getMessage(), e);
        }
        if (!Files.isWritable(path)) {
            throw new RuntimeException("Storage path '" + storagePath + "' is not writable. Please ensure the directory exists and the application has write permissions.");
        }
    }

    public void store(String itemName, InputStream content, long contentLength, String contentType) {
        Path filePath = Paths.get(this.storagePath, itemName);
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.copy(content, filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to store item '" + itemName + "': " + e.getMessage(), e);
        }
    }

    public StorageContent read(String itemName) {
        Path filePath = Paths.get(this.storagePath, itemName);
        try {
            InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);
            String contentType = Files.probeContentType(filePath);
            long contentLength = Files.size(filePath);
            return new StorageContent(inputStream, contentType, Long.valueOf(contentLength));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read item '" + itemName + "': " + e.getMessage(), e);
        }
    }

    public boolean exists(String itemName) {
        boolean bl;
        block8: {
            Path basePath = Paths.get(this.storagePath, new String[0]);
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + itemName);
            Stream<Path> paths = Files.walk(basePath, new FileVisitOption[0]);
            try {
                bl = paths.map(basePath::relativize).anyMatch(matcher::matches);
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            paths.close();
        }
        return bl;
    }

    public List<String> getChildren(String path) {
        List<String> list;
        block9: {
            Path basePath = Paths.get(this.storagePath, path);
            if (!Files.isDirectory(basePath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> paths = Files.walk(basePath, 1, new FileVisitOption[0]);
            try {
                list = paths.map(basePath::relativize).map(Path::toString).filter(istr -> !istr.isEmpty() && !istr.equals(".") && !istr.equals("..")).toList();
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read item '" + path + "': " + e.getMessage(), e);
                }
            }
            paths.close();
        }
        return list;
    }

    public void remove(String itemName) {
        block9: {
            Path filePath = Paths.get(this.storagePath, itemName);
            try {
                if (!Files.exists(filePath, new LinkOption[0])) break block9;
                if (Files.isDirectory(filePath, new LinkOption[0])) {
                    try (Stream<Path> paths = Files.walk(filePath, new FileVisitOption[0]);){
                        paths.sorted(Comparator.reverseOrder()).forEach(path -> {
                            try {
                                Files.delete(path);
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed to delete path '" + String.valueOf(path) + "': " + e.getMessage(), e);
                            }
                        });
                        break block9;
                    }
                }
                Files.delete(filePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to remove item '" + itemName + "': " + e.getMessage(), e);
            }
        }
    }
}

