/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.dto.PointInfo;
import com.dedicatedcode.reitti.dto.TimelineEntry;
import com.dedicatedcode.reitti.model.UnitSystem;
import com.dedicatedcode.reitti.model.geo.ProcessedVisit;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.geo.Trip;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSettings;
import com.dedicatedcode.reitti.repository.PreviewProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.PreviewRawLocationPointJdbcService;
import com.dedicatedcode.reitti.repository.PreviewTripJdbcService;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import com.dedicatedcode.reitti.service.TimelineService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimelineService {
    private static final Logger log = LoggerFactory.getLogger(TimelineService.class);
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final PreviewRawLocationPointJdbcService previewRawLocationPointJdbcService;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final PreviewProcessedVisitJdbcService previewProcessedVisitJdbcService;
    private final TripJdbcService tripJdbcService;
    private final PreviewTripJdbcService previewTripJdbcService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final ObjectMapper objectMapper;

    public TimelineService(RawLocationPointJdbcService rawLocationPointJdbcService, PreviewRawLocationPointJdbcService previewRawLocationPointJdbcService, ProcessedVisitJdbcService processedVisitJdbcService, PreviewProcessedVisitJdbcService previewProcessedVisitJdbcService, TripJdbcService tripJdbcService, PreviewTripJdbcService previewTripJdbcService, UserSettingsJdbcService userSettingsJdbcService, ObjectMapper objectMapper) {
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.previewRawLocationPointJdbcService = previewRawLocationPointJdbcService;
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.previewProcessedVisitJdbcService = previewProcessedVisitJdbcService;
        this.tripJdbcService = tripJdbcService;
        this.previewTripJdbcService = previewTripJdbcService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.objectMapper = objectMapper;
    }

    public List<TimelineEntry> buildTimelineEntries(User user, String previewId, ZoneId userTimeZone, LocalDate selectedDate, Instant startOfDay, Instant endOfDay) {
        List processedVisits = this.previewProcessedVisitJdbcService.findByUserAndTimeOverlap(user, previewId, startOfDay, endOfDay);
        List trips = this.previewTripJdbcService.findByUserAndTimeOverlap(user, previewId, startOfDay, endOfDay);
        UserSettings userSettings = this.userSettingsJdbcService.findByUserId(user.getId()).orElse(UserSettings.defaultSettings((Long)user.getId()));
        try {
            return this.buildTimelineEntries(user, previewId, processedVisits, trips, userTimeZone, selectedDate, userSettings);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to build timeline entries.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<TimelineEntry> buildTimelineEntries(User user, ZoneId userTimeZone, LocalDate selectedDate, Instant startOfDay, Instant endOfDay) {
        List processedVisits = this.processedVisitJdbcService.findByUserAndTimeOverlap(user, startOfDay, endOfDay);
        List trips = this.tripJdbcService.findByUserAndTimeOverlap(user, startOfDay, endOfDay);
        UserSettings userSettings = this.userSettingsJdbcService.findByUserId(user.getId()).orElse(UserSettings.defaultSettings((Long)user.getId()));
        try {
            return this.buildTimelineEntries(user, null, processedVisits, trips, userTimeZone, selectedDate, userSettings);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to build timeline entries.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<TimelineEntry> buildTimelineEntries(User user, String previewId, List<ProcessedVisit> processedVisits, List<Trip> trips, ZoneId timezone, LocalDate selectedDate, UserSettings userSettings) throws JsonProcessingException {
        ArrayList<TimelineEntry> entries = new ArrayList<TimelineEntry>();
        for (ProcessedVisit visit : processedVisits) {
            SignificantPlace place = visit.getPlace();
            if (place == null) continue;
            TimelineEntry entry = new TimelineEntry();
            entry.setId("visit-" + visit.getId());
            entry.setResourceId(visit.getId());
            entry.setType(TimelineEntry.Type.VISIT);
            entry.setPlace(place);
            entry.setStartTime(visit.getStartTime());
            entry.setStartTimezone(visit.getPlace().getTimezone());
            entry.setEndTime(visit.getEndTime());
            entry.setEndTimezone(visit.getPlace().getTimezone());
            entry.setFormattedTimeRange(this.formatTimeRange(visit.getStartTime(), visit.getEndTime(), timezone, selectedDate));
            entry.setFormattedLocalTimeRange(this.formatTimeRange(visit.getStartTime(), visit.getEndTime(), visit.getPlace().getTimezone(), selectedDate));
            entry.setFormattedDuration(this.formatDuration(visit.getStartTime(), visit.getEndTime()));
            entries.add(entry);
        }
        for (Trip trip : trips) {
            TimelineEntry entry = new TimelineEntry();
            entry.setId("trip-" + trip.getId());
            entry.setResourceId(trip.getId());
            entry.setType(TimelineEntry.Type.TRIP);
            entry.setStartTime(trip.getStartTime());
            entry.setStartTimezone(trip.getStartVisit().getPlace().getTimezone());
            entry.setEndTime(trip.getEndTime());
            entry.setEndTimezone(trip.getEndVisit().getPlace().getTimezone());
            entry.setFormattedTimeRange(this.formatTimeRange(trip.getStartTime(), trip.getEndTime(), timezone, selectedDate));
            entry.setFormattedDuration(this.formatDuration(trip.getStartTime(), trip.getEndTime()));
            entry.setFormattedLocalTimeRange(this.formatTimeRange(trip.getStartTime(), trip.getEndTime(), trip.getStartVisit().getPlace().getTimezone(), trip.getEndVisit().getPlace().getTimezone(), selectedDate));
            List path = previewId == null ? this.rawLocationPointJdbcService.findByUserAndTimestampBetweenOrderByTimestampAsc(user, trip.getStartTime(), trip.getEndTime()) : this.previewRawLocationPointJdbcService.findByUserAndTimestampBetweenOrderByTimestampAsc(user, previewId, trip.getStartTime(), trip.getEndTime());
            ArrayList<PointInfo> pathPoints = new ArrayList<PointInfo>();
            pathPoints.add(new PointInfo(trip.getStartVisit().getPlace().getLatitudeCentroid(), trip.getStartVisit().getPlace().getLongitudeCentroid(), trip.getStartTime(), Double.valueOf(0.0)));
            pathPoints.addAll(path.stream().map(p -> new PointInfo(p.getLatitude(), p.getLongitude(), p.getTimestamp(), p.getAccuracyMeters())).toList());
            pathPoints.add(new PointInfo(trip.getEndVisit().getPlace().getLatitudeCentroid(), trip.getEndVisit().getPlace().getLongitudeCentroid(), trip.getEndTime(), Double.valueOf(0.0)));
            entry.setPath(this.objectMapper.writeValueAsString(pathPoints));
            if (trip.getTravelledDistanceMeters() != null) {
                entry.setDistanceMeters(trip.getTravelledDistanceMeters());
                entry.setFormattedDistance(this.formatDistance(trip.getTravelledDistanceMeters(), userSettings.getUnitSystem()));
            } else if (trip.getEstimatedDistanceMeters() != null) {
                entry.setDistanceMeters(trip.getEstimatedDistanceMeters());
                entry.setFormattedDistance(this.formatDistance(trip.getEstimatedDistanceMeters(), userSettings.getUnitSystem()));
            }
            if (trip.getTransportModeInferred() != null) {
                entry.setTransportMode(trip.getTransportModeInferred());
            }
            entries.add(entry);
        }
        entries.sort(Comparator.comparing(TimelineEntry::getStartTime));
        return entries;
    }

    private String formatTimeRange(Instant startTime, Instant endTime, ZoneId startTimezone, ZoneId endTimezone, LocalDate selectedDate) {
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("MMM d HH:mm");
        LocalDate startDate = startTime.atZone(startTimezone).toLocalDate();
        LocalDate endDate = endTime.atZone(endTimezone).toLocalDate();
        LocalDate selectedDateInStartTimezone = selectedDate.atTime(10, 0).atZone(startTimezone).toLocalDate();
        LocalDate selectedDateInEndTimezone = selectedDate.atTime(10, 0).atZone(endTimezone).toLocalDate();
        String start = !startDate.equals(selectedDateInStartTimezone) ? startTime.atZone(startTimezone).format(dateTimeFormatter) : startTime.atZone(startTimezone).format(timeFormatter);
        String end = !endDate.equals(selectedDateInEndTimezone) ? endTime.atZone(endTimezone).format(dateTimeFormatter) : endTime.atZone(endTimezone).format(timeFormatter);
        return start + " - " + end;
    }

    private String formatTimeRange(Instant startTime, Instant endTime, ZoneId timezone, LocalDate selectedDate) {
        return this.formatTimeRange(startTime, endTime, timezone, timezone, selectedDate);
    }

    private String formatDuration(Instant startTime, Instant endTime) {
        long durationMinutes = Duration.between(startTime, endTime).toMinutes();
        long hours = durationMinutes / 60L;
        long minutes = durationMinutes % 60L;
        if (hours > 0L) {
            return hours + "h " + minutes + "m";
        }
        return minutes + "min";
    }

    private String formatDistance(Double distanceMeters, UnitSystem unitSystem) {
        if (distanceMeters == null) {
            return "";
        }
        switch (1.$SwitchMap$com$dedicatedcode$reitti$model$UnitSystem[unitSystem.ordinal()]) {
            case 1: {
                if (distanceMeters >= 1000.0) {
                    return String.format("%.1f km", distanceMeters / 1000.0);
                }
                return String.format("%.0f m", distanceMeters);
            }
            case 2: {
                double distanceFeet = distanceMeters * 3.28084;
                if (distanceFeet >= 5280.0) {
                    double distanceMiles = distanceFeet / 5280.0;
                    return String.format("%.1f mi", distanceMiles);
                }
                return String.format("%.0f ft", distanceFeet);
            }
        }
        return String.format("%.1f km", distanceMeters / 1000.0);
    }
}

