/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.model.Language;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.TimeDisplayMode;
import com.dedicatedcode.reitti.model.UnitSystem;
import com.dedicatedcode.reitti.model.geo.TransportMode;
import com.dedicatedcode.reitti.model.geo.TransportModeConfig;
import com.dedicatedcode.reitti.model.processing.DetectionParameter;
import com.dedicatedcode.reitti.model.processing.RecalculationState;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSettings;
import com.dedicatedcode.reitti.repository.ApiTokenJdbcService;
import com.dedicatedcode.reitti.repository.GeocodingResponseJdbcService;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.repository.SignificantPlaceJdbcService;
import com.dedicatedcode.reitti.repository.TransportModeJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import com.dedicatedcode.reitti.repository.VisitDetectionParametersJdbcService;
import java.time.ZoneId;
import java.util.List;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class UserService {
    private final UserJdbcService userJdbcService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final VisitDetectionParametersJdbcService visitDetectionParametersJdbcService;
    private final TransportModeJdbcService transportModeJdbcService;
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final SignificantPlaceJdbcService significantPlaceJdbcService;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final GeocodingResponseJdbcService geocodingResponseJdbcService;
    private final ApiTokenJdbcService apiTokenJdbcService;
    private final PasswordEncoder passwordEncoder;

    public UserService(UserJdbcService userJdbcService, UserSettingsJdbcService userSettingsJdbcService, VisitDetectionParametersJdbcService visitDetectionParametersJdbcService, TransportModeJdbcService transportModeJdbcService, RawLocationPointJdbcService rawLocationPointJdbcService, SignificantPlaceJdbcService significantPlaceJdbcService, ProcessedVisitJdbcService processedVisitJdbcService, GeocodingResponseJdbcService geocodingResponseJdbcService, ApiTokenJdbcService apiTokenJdbcService, PasswordEncoder passwordEncoder) {
        this.userJdbcService = userJdbcService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.visitDetectionParametersJdbcService = visitDetectionParametersJdbcService;
        this.transportModeJdbcService = transportModeJdbcService;
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.significantPlaceJdbcService = significantPlaceJdbcService;
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.geocodingResponseJdbcService = geocodingResponseJdbcService;
        this.apiTokenJdbcService = apiTokenJdbcService;
        this.passwordEncoder = passwordEncoder;
    }

    public User createNewUser(String username, String displayName, String externalId, String profileUrl) {
        User createdUser = this.userJdbcService.createUser(new User(username, displayName).withPassword("").withRole(Role.USER).withExternalId(externalId).withProfileUrl(profileUrl));
        this.saveDefaultVisitDetectionParameters(createdUser);
        this.saveDefaultTransportationModeDetectionParameters(createdUser);
        return createdUser;
    }

    public User createNewUser(String username, String displayName, String password, Role role, UnitSystem unitSystem, boolean preferColoredMap, Language preferredLanguage, Double homeLatitude, Double homeLongitude, String timezoneOverride, TimeDisplayMode timeDisplayMode, String color) {
        User createdUser = this.userJdbcService.createUser(new User(username, displayName).withPassword(this.passwordEncoder.encode((CharSequence)password)).withRole(role));
        UserSettings userSettings = new UserSettings(createdUser.getId(), preferColoredMap, preferredLanguage, unitSystem, homeLatitude, homeLongitude, StringUtils.hasText((String)timezoneOverride) ? ZoneId.of(timezoneOverride) : null, timeDisplayMode, null, null, color, null);
        this.saveDefaultVisitDetectionParameters(createdUser);
        this.saveDefaultTransportationModeDetectionParameters(createdUser);
        this.userSettingsJdbcService.save(userSettings);
        return createdUser;
    }

    private void saveDefaultTransportationModeDetectionParameters(User createdUser) {
        this.transportModeJdbcService.setTransportModeConfigs(createdUser, List.of(new TransportModeConfig(TransportMode.WALKING, Double.valueOf(7.0)), new TransportModeConfig(TransportMode.CYCLING, Double.valueOf(20.0)), new TransportModeConfig(TransportMode.DRIVING, Double.valueOf(120.0)), new TransportModeConfig(TransportMode.TRANSIT, null)));
    }

    private void saveDefaultVisitDetectionParameters(User createdUser) {
        this.visitDetectionParametersJdbcService.saveConfiguration(createdUser, new DetectionParameter(null, new DetectionParameter.VisitDetection(300L, 300L), new DetectionParameter.VisitMerging(48L, 300L, 200L), new DetectionParameter.LocationDensity(50.0, 1440L), null, RecalculationState.DONE));
    }

    @Transactional
    public void deleteUser(User user) {
        this.visitDetectionParametersJdbcService.findAllConfigurationsForUser(user).forEach(detectionParameter -> this.visitDetectionParametersJdbcService.delete(detectionParameter.getId()));
        this.transportModeJdbcService.deleteAllForUser(user);
        this.userSettingsJdbcService.deleteFor(user);
        this.geocodingResponseJdbcService.deleteAllForUser(user);
        this.processedVisitJdbcService.deleteAllForUser(user);
        this.significantPlaceJdbcService.deleteForUser(user);
        this.significantPlaceJdbcService.deleteForUser(user);
        this.rawLocationPointJdbcService.deleteAllForUser(user);
        this.rawLocationPointJdbcService.deleteAllForUser(user);
        this.apiTokenJdbcService.deleteForUser(user);
        this.userJdbcService.deleteUser(user.getId());
    }
}

