/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.event.SSEEvent;
import com.dedicatedcode.reitti.event.SSEType;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.integration.ReittiIntegrationService;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class UserSseEmitterService
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(UserSseEmitterService.class);
    private final ReittiIntegrationService reittiIntegrationService;
    private final Map<User, Set<SseEmitter>> userEmitters = new ConcurrentHashMap();

    public UserSseEmitterService(ReittiIntegrationService reittiIntegrationService) {
        this.reittiIntegrationService = reittiIntegrationService;
    }

    public SseEmitter addEmitter(User user2) {
        SseEmitter emitter = new SseEmitter(Long.valueOf(Long.MAX_VALUE));
        this.userEmitters.computeIfAbsent(user2, user -> new CopyOnWriteArraySet()).add(emitter);
        emitter.onCompletion(() -> {
            log.debug("SSE connection completed for user: [{}]", (Object)user2);
            this.removeEmitter(user2, emitter);
        });
        emitter.onTimeout(() -> {
            log.debug("SSE connection timed out for user: [{}]", (Object)user2);
            emitter.complete();
            this.removeEmitter(user2, emitter);
        });
        emitter.onError(throwable -> {
            log.error("SSE connection error for user [{}]: {}", (Object)user2, (Object)throwable.getMessage());
            this.removeEmitter(user2, emitter);
        });
        try {
            emitter.send(SseEmitter.event().data((Object)new SSEEvent(SSEType.CONNECTED, null, null, null, null)));
        }
        catch (IOException e) {
            log.error("Unable to send initial event for user [{}]", (Object)user2, (Object)e);
        }
        log.info("Emitter added for user: {}. Total emitters for user: {}", (Object)user2, (Object)((Set)this.userEmitters.get(user2)).size());
        return emitter;
    }

    public void sendEventToUser(User user, SSEEvent eventData) {
        Set emitters = (Set)this.userEmitters.get(user);
        if (emitters != null) {
            for (SseEmitter emitter : new CopyOnWriteArraySet(emitters)) {
                try {
                    emitter.send(SseEmitter.event().data((Object)eventData));
                    log.trace("Sent event to user: {}", (Object)user);
                }
                catch (IOException e) {
                    log.error("Error sending event to user {}: {}", (Object)user, (Object)e.getMessage());
                    emitter.completeWithError((Throwable)e);
                    this.removeEmitter(user, emitter);
                }
            }
        }
    }

    private void removeEmitter(User user, SseEmitter emitter) {
        Set emitters = (Set)this.userEmitters.get(user);
        if (emitters != null) {
            emitters.remove(emitter);
            if (emitters.isEmpty()) {
                this.userEmitters.remove(user);
                this.reittiIntegrationService.unsubscribeFromIntegrations(user);
            }
            log.info("Emitter removed for user: {}. Remaining emitters for user: {}", (Object)user, (Object)(this.userEmitters.containsKey(user) ? ((Set)this.userEmitters.get(user)).size() : 0));
        }
    }

    public void start() {
    }

    public void stop() {
        this.userEmitters.values().forEach(sseEmitters -> sseEmitters.forEach(ResponseBodyEmitter::complete));
    }

    public boolean isRunning() {
        return true;
    }
}

