/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class VersionService {
    private static final Logger log = LoggerFactory.getLogger(VersionService.class);
    private final Properties gitProperties = new Properties();
    private final MessageSource messageSource;

    public VersionService(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.loadGitProperties();
    }

    public String getVersion() {
        String property = this.gitProperties.getProperty("git.tags");
        if (!StringUtils.hasText((String)property)) {
            property = "development";
        }
        return property;
    }

    private void loadGitProperties() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("git.properties");){
            if (is != null) {
                this.gitProperties.load(is);
                log.info("git.properties loaded successfully.");
            } else {
                log.warn("git.properties not found on classpath. About section may not display Git information.");
            }
        }
        catch (IOException e) {
            log.error("Failed to load git.properties", (Throwable)e);
        }
    }

    public String getCommitDetails() {
        String commitId = this.gitProperties.getProperty("git.commit.id.abbrev", this.getMessage("about.not.available", new Object[0]));
        String commitTime = this.gitProperties.getProperty("git.commit.time");
        StringBuilder commitDetails = new StringBuilder();
        if (!commitId.equals(this.getMessage("about.not.available", new Object[0]))) {
            commitDetails.append(commitId);
            if (commitTime != null && !commitTime.isEmpty()) {
                commitDetails.append(" (").append(commitTime);
                commitDetails.append(")");
            }
        } else {
            commitDetails.append(this.getMessage("about.not.available", new Object[0]));
        }
        return commitDetails.toString();
    }

    public String getBuildTime() {
        return this.gitProperties.getProperty("git.build.time", this.getMessage("about.not.available", new Object[0]));
    }

    private String getMessage(String key, Object ... args) {
        return this.messageSource.getMessage(key, args, LocaleContextHolder.getLocale());
    }
}

