/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service;

import com.dedicatedcode.reitti.event.TriggerProcessingEvent;
import com.dedicatedcode.reitti.model.processing.DetectionParameter;
import com.dedicatedcode.reitti.model.security.User;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class VisitDetectionPreviewService {
    private static final Logger log = LoggerFactory.getLogger(VisitDetectionPreviewService.class);
    private static final int MAX_PREVIEW_ENTRIES = 1000;
    private static final long READY_THRESHOLD_SECONDS = 5L;
    private final JdbcTemplate jdbcTemplate;
    private final RabbitTemplate rabbitTemplate;
    private final Map<String, Instant> previewLastUpdated = new ConcurrentHashMap();

    public VisitDetectionPreviewService(JdbcTemplate jdbcTemplate, RabbitTemplate rabbitTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.rabbitTemplate = rabbitTemplate;
    }

    public String startPreview(User user, DetectionParameter config, Instant date) {
        log.info("Starting preview process for user {}", (Object)user.getId());
        LocalDateTime now = LocalDateTime.now();
        String previewId = UUID.randomUUID().toString();
        this.jdbcTemplate.update("INSERT INTO preview_visit_detection_parameters(user_id, valid_since, detection_minimum_stay_time_seconds,\ndetection_max_merge_time_between_same_stay_points, merging_search_duration_in_hours, merging_max_merge_time_between_same_visits, merging_min_distance_between_visits, preview_id, preview_created_at)\nVALUES (?,?,?,?,?,?,?,?,?)", new Object[]{user.getId(), config.getValidSince() != null ? Timestamp.from(config.getValidSince()) : null, config.getVisitDetection().getMinimumStayTimeInSeconds(), config.getVisitDetection().getMaxMergeTimeBetweenSameStayPoints(), config.getVisitMerging().getSearchDurationInHours(), config.getVisitMerging().getMaxMergeTimeBetweenSameVisits(), config.getVisitMerging().getMinDistanceBetweenVisits(), previewId, Timestamp.valueOf(now)});
        Timestamp start = Timestamp.from(date.minus(config.getVisitMerging().getSearchDurationInHours() * 2L, ChronoUnit.HOURS));
        Timestamp end = Timestamp.from(date.plus(1L, ChronoUnit.DAYS).plus(config.getVisitMerging().getSearchDurationInHours() * 2L, ChronoUnit.HOURS));
        this.jdbcTemplate.update("INSERT INTO preview_raw_location_points(accuracy_meters, timestamp, user_id, elevation_meters, geom, processed, version, ignored, synthetic, preview_id, preview_created_at) SELECT accuracy_meters, timestamp, user_id, elevation_meters, geom, false, version, ignored, synthetic, ?, ? FROM raw_location_points WHERE timestamp > ? AND timestamp <= ? AND user_id = ?", new Object[]{previewId, Timestamp.valueOf(now), start, end, user.getId()});
        log.debug("Copied preview data user [{}] with previewId [{}] successfully", (Object)user.getId(), (Object)previewId);
        TriggerProcessingEvent triggerEvent = new TriggerProcessingEvent(user.getUsername(), previewId, UUID.randomUUID().toString());
        this.rabbitTemplate.convertAndSend("reitti-exchange", "reitti.processing.start.v2", (Object)triggerEvent);
        this.updatePreviewStatus(previewId);
        return previewId;
    }

    public boolean isPreviewReady(String previewId) {
        Instant lastUpdate = (Instant)this.previewLastUpdated.get(previewId);
        if (lastUpdate == null) {
            return false;
        }
        return Instant.now().minusSeconds(5L).isAfter(lastUpdate);
    }

    public void updatePreviewStatus(String previewId) {
        if (previewId != null) {
            log.debug("Updating preview status for previewId: {}", (Object)previewId);
            this.previewLastUpdated.put(previewId, Instant.now());
            if (this.previewLastUpdated.size() > 1000) {
                Instant cutoff = Instant.now().minusSeconds(3600L);
                this.previewLastUpdated.entrySet().removeIf(entry -> ((Instant)entry.getValue()).isBefore(cutoff));
            }
        }
    }
}

