/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.geocoding;

import com.dedicatedcode.reitti.event.SignificantPlaceCreatedEvent;
import com.dedicatedcode.reitti.model.PlaceInformationOverride;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.PreviewSignificantPlaceJdbcService;
import com.dedicatedcode.reitti.repository.SignificantPlaceJdbcService;
import com.dedicatedcode.reitti.repository.SignificantPlaceOverrideJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.service.UserNotificationService;
import com.dedicatedcode.reitti.service.geocoding.GeocodeResult;
import com.dedicatedcode.reitti.service.geocoding.GeocodeServiceManager;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReverseGeocodingListener {
    private static final Logger logger = LoggerFactory.getLogger(ReverseGeocodingListener.class);
    private final SignificantPlaceJdbcService significantPlaceJdbcService;
    private final PreviewSignificantPlaceJdbcService previewSignificantPlaceJdbcService;
    private final GeocodeServiceManager geocodeServiceManager;
    private final SignificantPlaceOverrideJdbcService significantPlaceOverrideJdbcService;
    private final UserNotificationService userNotificationService;
    private final UserJdbcService userJdbcService;

    @Autowired
    public ReverseGeocodingListener(SignificantPlaceJdbcService significantPlaceJdbcService, PreviewSignificantPlaceJdbcService previewSignificantPlaceJdbcService, GeocodeServiceManager geocodeServiceManager, SignificantPlaceOverrideJdbcService significantPlaceOverrideJdbcService, UserNotificationService userNotificationService, UserJdbcService userJdbcService) {
        this.significantPlaceJdbcService = significantPlaceJdbcService;
        this.previewSignificantPlaceJdbcService = previewSignificantPlaceJdbcService;
        this.geocodeServiceManager = geocodeServiceManager;
        this.significantPlaceOverrideJdbcService = significantPlaceOverrideJdbcService;
        this.userNotificationService = userNotificationService;
        this.userJdbcService = userJdbcService;
    }

    public void handleSignificantPlaceCreated(SignificantPlaceCreatedEvent event) {
        Optional placeOptional;
        logger.info("Received SignificantPlaceCreatedEvent for place ID: {}", (Object)event.placeId());
        User user = (User)this.userJdbcService.findByUsername(event.username()).orElseThrow();
        Optional optional = placeOptional = event.previewId() == null ? this.significantPlaceJdbcService.findById(event.placeId()) : this.previewSignificantPlaceJdbcService.findById(event.placeId());
        if (placeOptional.isEmpty()) {
            logger.error("Could not find SignificantPlace with ID: {}", (Object)event.placeId());
            return;
        }
        SignificantPlace place = (SignificantPlace)placeOptional.get();
        try {
            Optional resultOpt = this.geocodeServiceManager.reverseGeocode(place, event.previewId() == null);
            if (resultOpt.isPresent()) {
                GeocodeResult result = (GeocodeResult)resultOpt.get();
                String label = result.label();
                String street = result.street();
                String houseNumber = result.houseNumber();
                String postcode = result.postcode();
                String city = result.city();
                SignificantPlace.PlaceType placeType = result.placeType();
                String countryCode = result.countryCode();
                String address = String.format("%s %s, %s %s", street, houseNumber, postcode, city);
                place = !label.isEmpty() ? place.withName(label).withAddress(address) : place.withName(street).withAddress(address);
                Optional override = this.significantPlaceOverrideJdbcService.findByUserAndPoint(user, place = place.withType(placeType).withCity(city).withCountryCode(countryCode));
                if (override.isPresent()) {
                    logger.info("Found override for place ID: {} with name: {}, type: {}, timezone: {}", new Object[]{place.getId(), ((PlaceInformationOverride)override.get()).name(), ((PlaceInformationOverride)override.get()).category(), ((PlaceInformationOverride)override.get()).timezone()});
                    place = place.withName(((PlaceInformationOverride)override.get()).name()).withType(((PlaceInformationOverride)override.get()).category()).withTimezone(((PlaceInformationOverride)override.get()).timezone());
                }
                if (event.previewId() == null) {
                    this.significantPlaceJdbcService.update(place.withGeocoded(true));
                    this.userNotificationService.placeUpdate(user, place);
                } else {
                    this.previewSignificantPlaceJdbcService.update(place.withGeocoded(true));
                    this.userNotificationService.placeUpdate(user, place, event.previewId());
                }
                logger.info("Updated place ID: {} with geocoding data: {}", (Object)place.getId(), (Object)label);
            } else {
                logger.warn("No geocoding results found for place ID: {}", (Object)place.getId());
            }
        }
        catch (Exception e) {
            logger.error("Error during reverse geocoding for place ID: {}", (Object)place.getId(), (Object)e);
        }
    }
}

