/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.importer;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.DefaultImportProcessor;
import com.dedicatedcode.reitti.service.importer.BaseGoogleTimelineImporter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGoogleTimelineImporter {
    private static final Logger logger = LoggerFactory.getLogger(BaseGoogleTimelineImporter.class);
    protected final ObjectMapper objectMapper;
    protected final DefaultImportProcessor batchProcessor;

    public BaseGoogleTimelineImporter(ObjectMapper objectMapper, DefaultImportProcessor batchProcessor) {
        this.objectMapper = objectMapper;
        this.batchProcessor = batchProcessor;
    }

    protected int handleVisit(User user, ZonedDateTime startTime, ZonedDateTime endTime, LatLng latLng, List<LocationPoint> batch) {
        logger.info("Found visit at [{}] from start [{}] to end [{}].", new Object[]{latLng, startTime, endTime});
        this.createAndScheduleLocationPoint(latLng, startTime, user, batch);
        this.createAndScheduleLocationPoint(latLng, endTime, user, batch);
        return 2;
    }

    protected void createAndScheduleLocationPoint(LatLng latLng, ZonedDateTime timestamp, User user, List<LocationPoint> batch) {
        LocationPoint point = new LocationPoint();
        point.setLatitude(Double.valueOf(latLng.latitude));
        point.setLongitude(Double.valueOf(latLng.longitude));
        point.setTimestamp(timestamp.withNano(0).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        point.setAccuracyMeters(Double.valueOf(10.0));
        batch.add(point);
        logger.trace("Created location point at [{}]", (Object)point);
        if (batch.size() >= this.batchProcessor.getBatchSize()) {
            this.batchProcessor.processBatch(user, batch);
            batch.clear();
        }
    }

    protected Optional<LatLng> parseLatLng(String input) {
        try {
            String[] coords = this.parseLatLngString(input);
            if (coords == null) {
                return Optional.empty();
            }
            return Optional.of(new LatLng(Double.parseDouble(coords[0]), Double.parseDouble(coords[1])));
        }
        catch (NumberFormatException e) {
            logger.warn("Error parsing LatLng string: {}", (Object)input);
            return Optional.empty();
        }
    }

    protected String[] parseLatLngString(String latLngStr) {
        if (latLngStr == null || latLngStr.trim().isEmpty()) {
            return null;
        }
        try {
            String cleaned = latLngStr.trim();
            cleaned = cleaned.startsWith("geo:") ? cleaned.substring(4) : cleaned.replace("\u00b0", "");
            String[] parts = cleaned.split(",");
            if (parts.length != 2) {
                return null;
            }
            String latStr = parts[0].trim();
            String lngStr = parts[1].trim();
            Double.parseDouble(latStr);
            Double.parseDouble(lngStr);
            return new String[]{latStr, lngStr};
        }
        catch (Exception e) {
            logger.warn("Failed to parse LatLng string: {}", (Object)latLngStr);
            return null;
        }
    }
}

