/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.importer;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.DefaultImportProcessor;
import com.dedicatedcode.reitti.service.ImportStateHolder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GeoJsonImporter {
    private static final Logger logger = LoggerFactory.getLogger(GeoJsonImporter.class);
    private final ObjectMapper objectMapper;
    private final ImportStateHolder stateHolder;
    private final DefaultImportProcessor batchProcessor;

    public GeoJsonImporter(ObjectMapper objectMapper, ImportStateHolder stateHolder, DefaultImportProcessor batchProcessor) {
        this.objectMapper = objectMapper;
        this.stateHolder = stateHolder;
        this.batchProcessor = batchProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> importGeoJson(InputStream inputStream, User user) {
        AtomicInteger processedCount = new AtomicInteger(0);
        try {
            this.stateHolder.importStarted();
            JsonNode rootNode = this.objectMapper.readTree(inputStream);
            if (!rootNode.has("type")) {
                Map<String, Object> map = Map.of("success", false, "error", "Invalid GeoJSON: missing 'type' field");
                return map;
            }
            String type = rootNode.get("type").asText();
            ArrayList<LocationPoint> batch = new ArrayList<LocationPoint>(this.batchProcessor.getBatchSize());
            Map<String, Object> map = type;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"FeatureCollection", "Feature", "Point"}, (String)((Object)map), n)) {
                case 0: {
                    if (!rootNode.has("features")) {
                        Map<String, Object> map2 = Map.of("success", false, "error", "Invalid FeatureCollection: missing 'features' array");
                        return map2;
                    }
                    JsonNode features = rootNode.get("features");
                    for (JsonNode feature : features) {
                        LocationPoint point = this.convertGeoJsonFeature(feature);
                        if (point == null) continue;
                        batch.add(point);
                        processedCount.incrementAndGet();
                        if (batch.size() < this.batchProcessor.getBatchSize()) continue;
                        this.batchProcessor.processBatch(user, batch);
                        batch.clear();
                    }
                    break;
                }
                case 1: {
                    LocationPoint point = this.convertGeoJsonFeature(rootNode);
                    if (point == null) break;
                    batch.add(point);
                    processedCount.incrementAndGet();
                    break;
                }
                case 2: {
                    LocationPoint point = this.convertGeoJsonGeometry(rootNode, null);
                    if (point == null) break;
                    batch.add(point);
                    processedCount.incrementAndGet();
                    break;
                }
                default: {
                    Map<String, Object> map3 = Map.of("success", false, "error", "Unsupported GeoJSON type: " + type + ". Only FeatureCollection, Feature, and Point are supported.");
                    return map3;
                }
            }
            if (!batch.isEmpty()) {
                this.batchProcessor.processBatch(user, batch);
            }
            logger.info("Imported and queued {} location points from GeoJSON file for user [{}]", (Object)processedCount.get(), (Object)user.getUsername());
            if (processedCount.get() == 0) {
                map = Map.of("success", false, "error", "No valid location points found in GeoJSON", "pointsReceived", 0);
                return map;
            }
            map = Map.of("success", true, "message", "Successfully queued " + processedCount.get() + " location points for processing", "pointsReceived", processedCount.get());
            return map;
        }
        catch (IOException e) {
            logger.error("Error processing GeoJSON file", (Throwable)e);
            Map<String, Object> map = Map.of("success", false, "error", "Error processing GeoJSON file: " + e.getMessage());
            return map;
        }
        finally {
            this.stateHolder.importFinished();
        }
    }

    private LocationPoint convertGeoJsonFeature(JsonNode feature) {
        if (!feature.has("geometry")) {
            return null;
        }
        JsonNode geometry = feature.get("geometry");
        JsonNode properties = feature.has("properties") ? feature.get("properties") : null;
        return this.convertGeoJsonGeometry(geometry, properties);
    }

    private LocationPoint convertGeoJsonGeometry(JsonNode geometry, JsonNode properties) {
        String[] accuracyFields;
        if (!geometry.has("type") || !"Point".equals(geometry.get("type").asText())) {
            return null;
        }
        if (!geometry.has("coordinates")) {
            return null;
        }
        JsonNode coordinates = geometry.get("coordinates");
        if (!coordinates.isArray() || coordinates.size() < 2) {
            return null;
        }
        LocationPoint point = new LocationPoint();
        double longitude = coordinates.get(0).asDouble();
        double latitude = coordinates.get(1).asDouble();
        point.setLatitude(Double.valueOf(latitude));
        point.setLongitude(Double.valueOf(longitude));
        String timestamp = null;
        if (properties != null) {
            String[] timestampFields;
            for (String field : timestampFields = new String[]{"timestamp", "time", "datetime", "date", "when"}) {
                if (!properties.has(field)) continue;
                timestamp = properties.get(field).asText();
                break;
            }
        }
        if (timestamp == null || timestamp.isEmpty()) {
            logger.warn("Could not determine timestamp for point {}. Will discard it", (Object)point);
            return null;
        }
        String isoTimestamp = this.convertToIsoTimestamp(timestamp);
        if (isoTimestamp == null) {
            logger.warn("Could not parse timestamp '{}' for point {}. Will discard it", (Object)timestamp, (Object)point);
            return null;
        }
        point.setTimestamp(isoTimestamp);
        Double accuracy = null;
        for (String field : accuracyFields = new String[]{"accuracy", "acc", "precision", "hdop"}) {
            if (properties == null || !properties.has(field)) continue;
            accuracy = properties.get(field).asDouble();
            break;
        }
        point.setAccuracyMeters(Double.valueOf(accuracy != null ? accuracy : 50.0));
        Double elevation = null;
        if (coordinates.size() >= 3) {
            try {
                elevation = coordinates.get(2).asDouble();
            }
            catch (Exception field) {
                // empty catch block
            }
        }
        if (elevation == null) {
            String[] elevationFields;
            for (String field : elevationFields = new String[]{"elevation", "ele", "altitude", "alt", "height"}) {
                if (!properties.has(field)) continue;
                try {
                    elevation = properties.get(field).asDouble();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        point.setElevationMeters(elevation);
        return point;
    }

    private String convertToIsoTimestamp(String timestamp) {
        try {
            long epochSeconds = Long.parseLong(timestamp);
            return Instant.ofEpochSecond(epochSeconds).toString();
        }
        catch (NumberFormatException e) {
            try {
                return ZonedDateTime.parse(timestamp).withZoneSameInstant(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_INSTANT);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

