/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.importer;

import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.DefaultImportProcessor;
import com.dedicatedcode.reitti.service.ImportStateHolder;
import com.dedicatedcode.reitti.service.importer.BaseGoogleTimelineImporter;
import com.dedicatedcode.reitti.service.importer.dto.ios.IOSSemanticSegment;
import com.dedicatedcode.reitti.service.importer.dto.ios.IOSVisit;
import com.dedicatedcode.reitti.service.importer.dto.ios.TimelinePathPoint;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GoogleIOSTimelineImporter
extends BaseGoogleTimelineImporter {
    private static final Logger logger = LoggerFactory.getLogger(GoogleIOSTimelineImporter.class);
    private final ImportStateHolder stateHolder;

    public GoogleIOSTimelineImporter(ObjectMapper objectMapper, ImportStateHolder stateHolder, DefaultImportProcessor batchProcessor) {
        super(objectMapper, batchProcessor);
        this.stateHolder = stateHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> importTimeline(InputStream inputStream, User user) {
        AtomicInteger processedCount = new AtomicInteger(0);
        try {
            this.stateHolder.importStarted();
            JsonFactory factory = this.objectMapper.getFactory();
            JsonParser parser = factory.createParser(inputStream);
            ArrayList batch = new ArrayList(this.batchProcessor.getBatchSize());
            List semanticSegments = (List)this.objectMapper.readValue(parser, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            logger.info("Found {} semantic segments", (Object)semanticSegments.size());
            for (IOSSemanticSegment semanticSegment : semanticSegments) {
                ZonedDateTime start = ZonedDateTime.parse(semanticSegment.getStartTime(), DateTimeFormatter.ISO_OFFSET_DATE_TIME).withNano(0);
                ZonedDateTime end = ZonedDateTime.parse(semanticSegment.getEndTime(), DateTimeFormatter.ISO_OFFSET_DATE_TIME).withNano(0);
                if (semanticSegment.getVisit() != null) {
                    IOSVisit visit = semanticSegment.getVisit();
                    Optional latLng = this.parseLatLng(visit.getTopCandidate().getPlaceLocation());
                    latLng.ifPresent(lng -> processedCount.addAndGet(this.handleVisit(user, start, end, lng, batch)));
                }
                if (semanticSegment.getTimelinePath() == null) continue;
                List timelinePath = semanticSegment.getTimelinePath();
                logger.info("Found timeline path from start [{}] to end [{}]. Will insert [{}] synthetic geo locations based on timeline path.", new Object[]{semanticSegment.getStartTime(), semanticSegment.getEndTime(), timelinePath.size()});
                for (TimelinePathPoint timelinePathPoint : timelinePath) {
                    this.parseLatLng(timelinePathPoint.getPoint()).ifPresent(location -> {
                        ZonedDateTime current = start.plusMinutes(Long.parseLong(timelinePathPoint.getDurationMinutesOffsetFromStartTime()));
                        this.createAndScheduleLocationPoint(location, current, user, batch);
                        processedCount.incrementAndGet();
                    });
                }
            }
            if (!batch.isEmpty()) {
                this.batchProcessor.processBatch(user, batch);
            }
            logger.info("Successfully imported and queued {} location points from Google Timeline for user {}", (Object)processedCount.get(), (Object)user.getUsername());
            Map<String, Integer> map = Map.of("success", true, "message", "Successfully queued " + processedCount.get() + " location points for processing", "pointsReceived", processedCount.get());
            return map;
        }
        catch (IOException e) {
            logger.error("Error processing Google Timeline file", (Throwable)e);
            Map<String, Object> map = Map.of("success", false, "error", "Error processing Google Timeline file: " + e.getMessage());
            return map;
        }
        finally {
            this.stateHolder.importFinished();
        }
    }
}

