/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.importer;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.DefaultImportProcessor;
import com.dedicatedcode.reitti.service.ImportStateHolder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GoogleRecordsImporter {
    private static final Logger logger = LoggerFactory.getLogger(GoogleRecordsImporter.class);
    private final ObjectMapper objectMapper;
    private final ImportStateHolder stateHolder;
    private final DefaultImportProcessor batchProcessor;

    public GoogleRecordsImporter(ObjectMapper objectMapper, ImportStateHolder stateHolder, DefaultImportProcessor batchProcessor) {
        this.objectMapper = objectMapper;
        this.stateHolder = stateHolder;
        this.batchProcessor = batchProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> importGoogleRecords(InputStream inputStream, User user) {
        AtomicInteger processedCount = new AtomicInteger(0);
        try {
            Map<String, Object> map;
            this.stateHolder.importStarted();
            JsonFactory factory = this.objectMapper.getFactory();
            JsonParser parser = factory.createParser(inputStream);
            ArrayList batch = new ArrayList(this.batchProcessor.getBatchSize());
            boolean foundData = false;
            while (parser.nextToken() != null) {
                String fieldName;
                if (parser.getCurrentToken() != JsonToken.FIELD_NAME || !"locations".equals(fieldName = parser.currentName())) continue;
                foundData = true;
                processedCount.addAndGet(this.processLocationsArray(parser, batch, user));
                break;
            }
            if (!foundData) {
                map = Map.of("success", false, "error", "Invalid format: 'locations' array not found in Records.json");
                return map;
            }
            if (!batch.isEmpty()) {
                this.batchProcessor.processBatch(user, batch);
            }
            logger.info("Successfully imported and queued {} location points from Google Records for user {}", (Object)processedCount.get(), (Object)user.getUsername());
            map = Map.of("success", true, "message", "Successfully queued " + processedCount.get() + " location points for processing", "pointsReceived", processedCount.get());
            return map;
        }
        catch (IOException e) {
            logger.error("Error processing Google Records file", (Throwable)e);
            Map<String, Object> map = Map.of("success", false, "error", "Error processing Google Records file: " + e.getMessage());
            return map;
        }
        finally {
            this.stateHolder.importFinished();
        }
    }

    private int processLocationsArray(JsonParser parser, List<LocationPoint> batch, User user) throws IOException {
        int processedCount = 0;
        parser.nextToken();
        if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new IOException("Invalid format: 'locations' is not an array");
        }
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
            JsonNode locationNode = (JsonNode)this.objectMapper.readTree(parser);
            try {
                LocationPoint point = this.convertGoogleRecordsLocation(locationNode);
                if (point == null) continue;
                batch.add(point);
                ++processedCount;
                if (batch.size() < this.batchProcessor.getBatchSize()) continue;
                this.batchProcessor.processBatch(user, batch);
                batch.clear();
            }
            catch (Exception e) {
                logger.warn("Error processing location entry: {}", (Object)e.getMessage());
            }
        }
        return processedCount;
    }

    private LocationPoint convertGoogleRecordsLocation(JsonNode locationNode) {
        if (!(locationNode.has("latitudeE7") && locationNode.has("longitudeE7") && locationNode.has("timestamp"))) {
            return null;
        }
        LocationPoint point = new LocationPoint();
        double latitude = locationNode.get("latitudeE7").asDouble() / 1.0E7;
        double longitude = locationNode.get("longitudeE7").asDouble() / 1.0E7;
        point.setLatitude(Double.valueOf(latitude));
        point.setLongitude(Double.valueOf(longitude));
        point.setTimestamp(locationNode.get("timestamp").asText());
        if (locationNode.has("accuracy")) {
            point.setAccuracyMeters(Double.valueOf(locationNode.get("accuracy").asDouble()));
        } else {
            point.setAccuracyMeters(Double.valueOf(10.0));
        }
        return point;
    }
}

