/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.importer;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.ImportProcessor;
import com.dedicatedcode.reitti.service.ImportStateHolder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component
public class GpxImporter {
    private static final Logger logger = LoggerFactory.getLogger(GpxImporter.class);
    private static final int BATCH_SIZE = 1000;
    private final ImportStateHolder stateHolder;
    private final ImportProcessor batchProcessor;

    public GpxImporter(ImportStateHolder stateHolder, ImportProcessor batchProcessor) {
        this.stateHolder = stateHolder;
        this.batchProcessor = batchProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> importGpx(InputStream inputStream, User user) {
        AtomicInteger processedCount = new AtomicInteger(0);
        try {
            this.stateHolder.importStarted();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            document.getDocumentElement().normalize();
            NodeList trackPoints = document.getElementsByTagName("trkpt");
            ArrayList<LocationPoint> batch = new ArrayList<LocationPoint>();
            for (int i = 0; i < trackPoints.getLength(); ++i) {
                Element trackPoint = (Element)trackPoints.item(i);
                try {
                    LocationPoint point = this.convertGpxTrackPoint(trackPoint);
                    if (point == null) continue;
                    batch.add(point);
                    processedCount.incrementAndGet();
                    if (batch.size() < 1000) continue;
                    this.batchProcessor.processBatch(user, batch);
                    batch.clear();
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Error processing GPX track point: {}", (Object)e.getMessage());
                }
            }
            if (!batch.isEmpty()) {
                this.batchProcessor.processBatch(user, batch);
            }
            logger.info("Successfully imported and queued {} location points from GPX file for user {}", (Object)processedCount.get(), (Object)user.getUsername());
            Map<String, Object> map = Map.of("success", true, "message", "Successfully queued " + processedCount.get() + " location points for processing", "pointsReceived", processedCount.get());
            return map;
        }
        catch (Exception e) {
            logger.error("Error processing GPX file", (Throwable)e);
            Map<String, Object> map = Map.of("success", false, "error", "Error processing GPX file: " + e.getMessage());
            return map;
        }
        finally {
            this.stateHolder.importFinished();
        }
    }

    private LocationPoint convertGpxTrackPoint(Element trackPoint) {
        String elevationStr;
        String timeStr;
        if (!trackPoint.hasAttribute("lat") || !trackPoint.hasAttribute("lon")) {
            return null;
        }
        LocationPoint point = new LocationPoint();
        double latitude = Double.parseDouble(trackPoint.getAttribute("lat"));
        double longitude = Double.parseDouble(trackPoint.getAttribute("lon"));
        point.setLatitude(Double.valueOf(latitude));
        point.setLongitude(Double.valueOf(longitude));
        NodeList timeElements = trackPoint.getElementsByTagName("time");
        if (timeElements.getLength() > 0) {
            timeStr = timeElements.item(0).getTextContent();
            if (!StringUtils.hasText((String)timeStr)) {
                return null;
            }
        } else {
            return null;
        }
        point.setTimestamp(timeStr);
        point.setAccuracyMeters(Double.valueOf(10.0));
        NodeList elevationElements = trackPoint.getElementsByTagName("ele");
        if (elevationElements.getLength() > 0 && StringUtils.hasText((String)(elevationStr = elevationElements.item(0).getTextContent()))) {
            try {
                double elevation = Double.parseDouble(elevationStr);
                point.setElevationMeters(Double.valueOf(elevation));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return point;
    }
}

