/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.integration;

import com.dedicatedcode.reitti.dto.ImmichAsset;
import com.dedicatedcode.reitti.dto.ImmichSearchRequest;
import com.dedicatedcode.reitti.dto.ImmichSearchResponse;
import com.dedicatedcode.reitti.dto.PhotoResponse;
import com.dedicatedcode.reitti.model.IntegrationTestResult;
import com.dedicatedcode.reitti.model.geo.RawLocationPoint;
import com.dedicatedcode.reitti.model.integration.ImmichIntegration;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ImmichIntegrationJdbcService;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.service.StorageService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ImmichIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(ImmichIntegrationService.class);
    private final ImmichIntegrationJdbcService immichIntegrationJdbcService;
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final RestTemplate restTemplate;
    private final StorageService storageService;

    public ImmichIntegrationService(ImmichIntegrationJdbcService immichIntegrationJdbcService, RawLocationPointJdbcService rawLocationPointJdbcService, RestTemplate restTemplate, StorageService storageService) {
        this.immichIntegrationJdbcService = immichIntegrationJdbcService;
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.restTemplate = restTemplate;
        this.storageService = storageService;
    }

    public Optional<ImmichIntegration> getIntegrationForUser(User user) {
        return this.immichIntegrationJdbcService.findByUser(user);
    }

    @Transactional
    public ImmichIntegration saveIntegration(User user, String serverUrl, String apiToken, boolean enabled) {
        Optional existingIntegration = this.immichIntegrationJdbcService.findByUser(user);
        ImmichIntegration integration = existingIntegration.isPresent() ? ((ImmichIntegration)existingIntegration.get()).withServerUrl(serverUrl).withApiToken(apiToken).withEnabled(enabled) : new ImmichIntegration(serverUrl, apiToken, enabled);
        return this.immichIntegrationJdbcService.save(user, integration);
    }

    public IntegrationTestResult testConnection(String serverUrl, String apiToken) {
        if (serverUrl == null || serverUrl.trim().isEmpty() || apiToken == null || apiToken.trim().isEmpty()) {
            return IntegrationTestResult.failed();
        }
        try {
            Object baseUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
            String validateUrl = (String)baseUrl + "api/auth/validateToken";
            HttpHeaders headers = new HttpHeaders();
            headers.add("x-api-key", apiToken);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(validateUrl, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                return IntegrationTestResult.ok();
            }
            return IntegrationTestResult.failed((String)("StatusCode: " + String.valueOf(response.getStatusCode()) + " Message:" + (String)response.getBody()));
        }
        catch (Exception e) {
            return new IntegrationTestResult(false, e.getMessage());
        }
    }

    public List<PhotoResponse> searchPhotosForRange(User user, LocalDate start, LocalDate end, String timezone) {
        Optional integrationOpt = this.getIntegrationForUser(user);
        if (integrationOpt.isEmpty() || !((ImmichIntegration)integrationOpt.get()).isEnabled()) {
            return new ArrayList<PhotoResponse>();
        }
        ImmichIntegration integration = (ImmichIntegration)integrationOpt.get();
        try {
            Object baseUrl = integration.getServerUrl().endsWith("/") ? integration.getServerUrl() : integration.getServerUrl() + "/";
            String searchUrl = (String)baseUrl + "api/search/metadata";
            ZoneId userTimezone = ZoneId.of(timezone);
            Instant startOfDay = start.atStartOfDay(userTimezone).toInstant();
            Instant endOfDay = end.plusDays(1L).atStartOfDay(userTimezone).toInstant().minusMillis(1L);
            ImmichSearchRequest searchRequest = new ImmichSearchRequest(DateTimeFormatter.ISO_INSTANT.format(startOfDay), DateTimeFormatter.ISO_INSTANT.format(endOfDay));
            HttpHeaders headers = new HttpHeaders();
            headers.add("x-api-key", integration.getApiToken());
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            HttpEntity entity = new HttpEntity((Object)searchRequest, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(searchUrl, HttpMethod.POST, entity, ImmichSearchResponse.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return this.convertToPhotoResponses(user, (ImmichSearchResponse)response.getBody(), (String)baseUrl);
            }
        }
        catch (Exception e) {
            log.error("Unable to search immich data:", (Throwable)e);
        }
        return new ArrayList<PhotoResponse>();
    }

    private List<PhotoResponse> convertToPhotoResponses(User user, ImmichSearchResponse searchResponse, String baseUrl) {
        ArrayList<PhotoResponse> photos = new ArrayList<PhotoResponse>();
        if (searchResponse.getAssets() != null && searchResponse.getAssets().getItems() != null) {
            for (ImmichAsset asset : searchResponse.getAssets().getItems()) {
                String thumbnailUrl = "/api/v1/photos/immich/proxy/" + asset.getId() + "/thumbnail";
                String fullImageUrl = "/api/v1/photos/immich/proxy/" + asset.getId() + "/original";
                Double latitude = null;
                Double longitude = null;
                String dateTime = asset.getLocalDateTime();
                boolean timeMatched = false;
                if (asset.getExifInfo() != null) {
                    latitude = asset.getExifInfo().getLatitude();
                    longitude = asset.getExifInfo().getLongitude();
                    if (asset.getExifInfo().getDateTimeOriginal() != null) {
                        dateTime = asset.getExifInfo().getDateTimeOriginal();
                    }
                }
                if (latitude == null && longitude == null) {
                    log.debug("Asset [{}] had no exif data, will try to match it to a point we know of.", (Object)asset.getId());
                    ZonedDateTime takenAt = ZonedDateTime.parse(dateTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    ZonedDateTime utc = takenAt.withZoneSameInstant(ZoneId.of("UTC"));
                    Optional proximatePoint = this.rawLocationPointJdbcService.findProximatePoint(user, utc.toInstant(), 60);
                    if (proximatePoint.isPresent()) {
                        latitude = ((RawLocationPoint)proximatePoint.get()).getLatitude();
                        longitude = ((RawLocationPoint)proximatePoint.get()).getLongitude();
                        timeMatched = true;
                    }
                }
                PhotoResponse photo = new PhotoResponse(asset.getId(), asset.getOriginalFileName(), thumbnailUrl, fullImageUrl, latitude, longitude, dateTime, timeMatched);
                photos.add(photo);
            }
        }
        return photos;
    }

    public ResponseEntity<byte[]> proxyImageRequest(User user, String assetId, String size) {
        Optional integrationOpt = this.getIntegrationForUser(user);
        if (integrationOpt.isEmpty() || !((ImmichIntegration)integrationOpt.get()).isEnabled()) {
            return ResponseEntity.notFound().build();
        }
        ImmichIntegration integration = (ImmichIntegration)integrationOpt.get();
        try {
            Object baseUrl = integration.getServerUrl().endsWith("/") ? integration.getServerUrl() : integration.getServerUrl() + "/";
            String imageUrl = (String)baseUrl + "api/assets/" + assetId + "/thumbnail?size=" + size;
            HttpHeaders headers = new HttpHeaders();
            headers.add("x-api-key", integration.getApiToken());
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(imageUrl, HttpMethod.GET, entity, byte[].class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                HttpHeaders responseHeaders = new HttpHeaders();
                if (response.getHeaders().getContentType() != null) {
                    responseHeaders.setContentType(response.getHeaders().getContentType());
                } else {
                    responseHeaders.setContentType(MediaType.IMAGE_JPEG);
                }
                responseHeaders.setCacheControl("public, max-age=3600");
                return new ResponseEntity((Object)((byte[])response.getBody()), (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
            }
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.notFound().build();
    }

    public String downloadImage(User user, String assetId, String targetPath) {
        byte[] imageData;
        ResponseEntity response = this.proxyImageRequest(user, assetId, "fullsize");
        if (response.getStatusCode().is2xxSuccessful() && (imageData = (byte[])response.getBody()) != null) {
            String contentType = response.getHeaders().getContentType() != null ? response.getHeaders().getContentType().toString() : "image/jpeg";
            long contentLength = imageData.length;
            String filename = assetId + this.getExtensionFromContentType(contentType);
            this.storageService.store(targetPath + "/" + filename, (InputStream)new ByteArrayInputStream(imageData), contentLength, contentType);
            return filename;
        }
        throw new IllegalStateException("Unable to download image from Immich");
    }

    private String getExtensionFromContentType(String contentType) {
        String string = contentType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"image/jpeg", "image/png", "image/gif", "image/webp"}, (String)string, n)) {
            case 0 -> ".jpg";
            case 1 -> ".png";
            case 2 -> ".gif";
            case 3 -> ".webp";
            default -> ".jpg";
        };
    }
}

