/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.integration;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.dto.OwntracksLocationRequest;
import com.dedicatedcode.reitti.model.integration.OwnTracksRecorderIntegration;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.OwnTracksRecorderIntegrationJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.service.ImportProcessor;
import com.dedicatedcode.reitti.service.integration.OwnTracksRecorderIntegrationService;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class OwnTracksRecorderIntegrationService {
    private static final Logger logger = LoggerFactory.getLogger(OwnTracksRecorderIntegrationService.class);
    private final OwnTracksRecorderIntegrationJdbcService jdbcService;
    private final UserJdbcService userJdbcService;
    private final RestTemplate restTemplate;
    private final ImportProcessor importBatchProcessor;

    public OwnTracksRecorderIntegrationService(OwnTracksRecorderIntegrationJdbcService jdbcService, UserJdbcService userJdbcService, ImportProcessor importBatchProcessor) {
        this.jdbcService = jdbcService;
        this.userJdbcService = userJdbcService;
        this.importBatchProcessor = importBatchProcessor;
        this.restTemplate = new RestTemplate();
    }

    @Scheduled(cron="${reitti.imports.owntracks-recorder.schedule}")
    void importNewData() {
        logger.trace("Starting OwnTracks Recorder data import");
        List allUsers = this.userJdbcService.findAll();
        int processedIntegrations = 0;
        int totalLocationPoints = 0;
        for (User user : allUsers) {
            Optional integrationOpt = this.jdbcService.findByUser(user);
            if (integrationOpt.isEmpty() || !((OwnTracksRecorderIntegration)integrationOpt.get()).isEnabled()) continue;
            OwnTracksRecorderIntegration integration = (OwnTracksRecorderIntegration)integrationOpt.get();
            ++processedIntegrations;
            try {
                Instant fromTime = integration.getLastSuccessfulFetch() != null ? integration.getLastSuccessfulFetch() : Instant.now().minus(5L, ChronoUnit.MINUTES);
                List locationData = this.fetchLocationData(integration, fromTime);
                if (locationData.isEmpty()) continue;
                ArrayList<LocationPoint> validPoints = new ArrayList<LocationPoint>();
                for (OwntracksLocationRequest owntracksData : locationData) {
                    LocationPoint locationPoint;
                    if (!owntracksData.isLocationUpdate() || (locationPoint = owntracksData.toLocationPoint()).getTimestamp() == null || locationPoint.getAccuracyMeters() == null) continue;
                    validPoints.add(locationPoint);
                }
                if (validPoints.isEmpty()) continue;
                this.importBatchProcessor.processBatch(user, validPoints);
                totalLocationPoints += validPoints.size();
                logger.info("Imported {} location points for user {}", (Object)validPoints.size(), (Object)user.getUsername());
                Instant latestTimestamp = validPoints.stream().map(LocationPoint::getTimestamp).filter(Objects::nonNull).map(Instant::parse).max(Instant::compareTo).orElse(null);
                if (latestTimestamp == null) continue;
                OwnTracksRecorderIntegration updatedIntegration = integration.withLastSuccessfulFetch(latestTimestamp);
                this.jdbcService.update(updatedIntegration);
            }
            catch (Exception e) {
                logger.error("Failed to import data for user {} from OwnTracks Recorder: {}", new Object[]{user.getUsername(), e.getMessage(), e});
            }
        }
        logger.trace("OwnTracks Recorder import completed: processed {} integrations, imported {} location points", (Object)processedIntegrations, (Object)totalLocationPoints);
    }

    public Optional<OwnTracksRecorderIntegration> getIntegrationForUser(User user) {
        return this.jdbcService.findByUser(user);
    }

    public OwnTracksRecorderIntegration saveIntegration(User user, String baseUrl, String username, String authUsername, String authPassword, String deviceId, boolean enabled) {
        Optional existingIntegration;
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("Base URL cannot be empty");
        }
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("Username cannot be empty");
        }
        if (deviceId == null || deviceId.trim().isEmpty()) {
            throw new IllegalArgumentException("Device ID cannot be empty");
        }
        String normalizedBaseUrl = baseUrl.trim();
        if (normalizedBaseUrl.endsWith("/")) {
            normalizedBaseUrl = normalizedBaseUrl.substring(0, normalizedBaseUrl.length() - 1);
        }
        if ((existingIntegration = this.jdbcService.findByUser(user)).isPresent()) {
            OwnTracksRecorderIntegration existing = (OwnTracksRecorderIntegration)existingIntegration.get();
            OwnTracksRecorderIntegration updated = new OwnTracksRecorderIntegration(existing.getId(), normalizedBaseUrl, username.trim(), deviceId.trim(), authUsername, authPassword, enabled, existing.getLastSuccessfulFetch(), existing.getVersion());
            return this.jdbcService.update(updated);
        }
        OwnTracksRecorderIntegration newIntegration = new OwnTracksRecorderIntegration(normalizedBaseUrl, username.trim(), deviceId.trim(), enabled, authUsername, authPassword);
        return this.jdbcService.save(user, newIntegration);
    }

    public boolean testConnection(String baseUrl, String username, String authUsername, String authPassword, String deviceId) {
        String normalizedBaseUrl = baseUrl.trim();
        if (normalizedBaseUrl.endsWith("/")) {
            normalizedBaseUrl = normalizedBaseUrl.substring(0, normalizedBaseUrl.length() - 1);
        }
        String testUrl = normalizedBaseUrl + "/api/0/locations?user=%s&device=%s".formatted(username, deviceId);
        logger.debug("Testing OwnTracks Recorder connection to: {}", (Object)testUrl);
        HttpEntity entity = this.createHttpEntityWithAuth(authUsername, authPassword);
        ResponseEntity response = this.restTemplate.exchange(testUrl, HttpMethod.GET, entity, String.class, new Object[0]);
        HttpStatus statusCode = (HttpStatus)response.getStatusCode();
        boolean isSuccessful = statusCode.is2xxSuccessful() || statusCode == HttpStatus.UNAUTHORIZED || statusCode == HttpStatus.FORBIDDEN;
        logger.debug("OwnTracks Recorder connection test result: {} (status: {})", (Object)isSuccessful, (Object)statusCode);
        return isSuccessful;
    }

    public void deleteIntegration(User user) {
        Optional integration = this.jdbcService.findByUser(user);
        integration.ifPresent(arg_0 -> ((OwnTracksRecorderIntegrationJdbcService)this.jdbcService).delete(arg_0));
    }

    public void loadHistoricalData(User user) {
        Optional integrationOpt = this.jdbcService.findByUser(user);
        if (integrationOpt.isEmpty() || !((OwnTracksRecorderIntegration)integrationOpt.get()).isEnabled()) {
            throw new IllegalStateException("No enabled OwnTracks Recorder integration found for user");
        }
        OwnTracksRecorderIntegration integration = (OwnTracksRecorderIntegration)integrationOpt.get();
        try {
            Set availableMonths = this.fetchAvailableMonths(integration);
            if (availableMonths.isEmpty()) {
                logger.info("No historical data found for user {}", (Object)user.getUsername());
                return;
            }
            logger.info("Found {} months of historical data for user {}", (Object)availableMonths.size(), (Object)user.getUsername());
            int totalLocationPoints = 0;
            for (YearMonth month : availableMonths) {
                try {
                    List monthlyLocationData = this.fetchLocationDataForMonth(integration, month);
                    if (monthlyLocationData.isEmpty()) continue;
                    ArrayList<LocationPoint> validPoints = new ArrayList<LocationPoint>();
                    for (OwntracksLocationRequest owntracksData : monthlyLocationData) {
                        LocationPoint locationPoint;
                        if (!owntracksData.isLocationUpdate() || (locationPoint = owntracksData.toLocationPoint()).getTimestamp() == null || locationPoint.getAccuracyMeters() == null) continue;
                        validPoints.add(locationPoint);
                    }
                    if (validPoints.isEmpty()) continue;
                    this.importBatchProcessor.processBatch(user, validPoints);
                    totalLocationPoints += validPoints.size();
                    logger.debug("Loaded {} location points for user {} from month {}", new Object[]{validPoints.size(), user.getUsername(), month});
                }
                catch (Exception e) {
                    logger.error("Failed to load data for user {} from month {}: {}", new Object[]{user.getUsername(), month, e.getMessage(), e});
                }
            }
            logger.info("Loaded {} total historical location points for user {}", (Object)totalLocationPoints, (Object)user.getUsername());
        }
        catch (Exception e) {
            logger.error("Failed to load historical data for user {} from OwnTracks Recorder: {}", new Object[]{user.getUsername(), e.getMessage(), e});
            throw new RuntimeException("Failed to load historical data: " + e.getMessage(), e);
        }
    }

    private List<OwntracksLocationRequest> fetchLocationData(OwnTracksRecorderIntegration integration, Instant fromTime) {
        try {
            if (fromTime == null) {
                fromTime = Instant.ofEpochSecond(0L);
            }
            LocalDateTime fromDate = fromTime.atOffset(ZoneOffset.UTC).toLocalDateTime();
            String fromDateString = fromDate.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            String apiUrl = String.format("%s/api/0/locations?user=%s&device=%s&from=%s&limit=500", integration.getBaseUrl(), integration.getUsername(), integration.getDeviceId(), fromDateString);
            return this.fetchData(apiUrl, integration);
        }
        catch (Exception e) {
            logger.error("Failed to fetch location data from OwnTracks Recorder: {}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    private List<OwntracksLocationRequest> fetchData(String apiUrl, OwnTracksRecorderIntegration integration) {
        logger.info("Fetching location data from: {}", (Object)apiUrl);
        HttpEntity entity = this.createHttpEntityWithAuth(integration.getAuthUsername(), integration.getAuthPassword());
        ResponseEntity response = this.restTemplate.exchange(apiUrl, HttpMethod.GET, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
            logger.debug("Successfully fetched {} location records from OwnTracks Recorder", (Object)((OwntracksRecorderResponse)response.getBody()).data.size());
            return ((OwntracksRecorderResponse)response.getBody()).data;
        }
        logger.warn("Unexpected response from OwnTracks Recorder: {}", (Object)response.getStatusCode());
        return Collections.emptyList();
    }

    private Set<YearMonth> fetchAvailableMonths(OwnTracksRecorderIntegration integration) {
        try {
            String recsUrl = String.format("%s/api/0/list?user=%s&device=%s", integration.getBaseUrl(), integration.getUsername(), integration.getDeviceId());
            logger.debug("Fetching available recs from: {}", (Object)recsUrl);
            HttpEntity entity = this.createHttpEntityWithAuth(integration.getAuthUsername(), integration.getAuthPassword());
            ResponseEntity response = this.restTemplate.exchange(recsUrl, HttpMethod.GET, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                HashSet<YearMonth> months = new HashSet<YearMonth>();
                Pattern datePattern = Pattern.compile("/(\\d{4})-(\\d{2})\\.rec$");
                for (String recPath : ((OwntracksRecsResponse)response.getBody()).results) {
                    Matcher matcher = datePattern.matcher(recPath);
                    if (!matcher.find()) continue;
                    int year = Integer.parseInt(matcher.group(1));
                    int month = Integer.parseInt(matcher.group(2));
                    months.add(YearMonth.of(year, month));
                }
                logger.debug("Extracted {} unique months from {} rec files", (Object)months.size(), (Object)((OwntracksRecsResponse)response.getBody()).results.size());
                return months;
            }
            logger.warn("Unexpected response when fetching recs: {}", (Object)response.getStatusCode());
            return Collections.emptySet();
        }
        catch (Exception e) {
            logger.error("Failed to fetch available months from OwnTracks Recorder: {}", (Object)e.getMessage());
            return Collections.emptySet();
        }
    }

    private List<OwntracksLocationRequest> fetchLocationDataForMonth(OwnTracksRecorderIntegration integration, YearMonth month) {
        try {
            LocalDateTime fromDate = month.atDay(1).atStartOfDay();
            LocalDateTime toDate = month.atEndOfMonth().atTime(23, 59, 59);
            String fromDateString = fromDate.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            String toDateString = toDate.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            String apiUrl = String.format("%s/api/0/locations?user=%s&device=%s&from=%s&to=%s&limit=10000", integration.getBaseUrl(), integration.getUsername(), integration.getDeviceId(), fromDateString, toDateString);
            return this.fetchData(apiUrl, integration);
        }
        catch (Exception e) {
            logger.error("Failed to fetch location data for month {}: {}", (Object)month, (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    private HttpEntity<String> createHttpEntityWithAuth(String authUsername, String authPassword) {
        HttpHeaders headers = new HttpHeaders();
        if (authUsername != null && !authUsername.trim().isEmpty() && authPassword != null && !authPassword.trim().isEmpty()) {
            String auth = authUsername + ":" + authPassword;
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            String authHeader = "Basic " + new String(encodedAuth);
            headers.set("Authorization", authHeader);
        }
        return new HttpEntity((MultiValueMap)headers);
    }
}

