/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.integration;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.dto.PlaceInfo;
import com.dedicatedcode.reitti.dto.ProcessedVisitResponse;
import com.dedicatedcode.reitti.dto.ReittiRemoteInfo;
import com.dedicatedcode.reitti.dto.SubscriptionRequest;
import com.dedicatedcode.reitti.dto.SubscriptionResponse;
import com.dedicatedcode.reitti.dto.TimelineEntry;
import com.dedicatedcode.reitti.dto.UserTimelineData;
import com.dedicatedcode.reitti.model.geo.GeoPoint;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.integration.ReittiIntegration;
import com.dedicatedcode.reitti.model.security.RemoteUser;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.OptimisticLockException;
import com.dedicatedcode.reitti.repository.ReittiIntegrationJdbcService;
import com.dedicatedcode.reitti.service.AvatarService;
import com.dedicatedcode.reitti.service.RequestFailedException;
import com.dedicatedcode.reitti.service.RequestTemporaryFailedException;
import com.dedicatedcode.reitti.service.integration.ReittiIntegrationService;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class ReittiIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(ReittiIntegrationService.class);
    private static final List<ReittiIntegration.Status> VALID_INTEGRATION_STATUS = List.of(ReittiIntegration.Status.ACTIVE, ReittiIntegration.Status.RECOVERABLE);
    private final String advertiseUri;
    private final ReittiIntegrationJdbcService jdbcService;
    private final JdbcTemplate jdbcTemplate;
    private final RestTemplate restTemplate;
    private final AvatarService avatarService;
    private final Map<Long, String> integrationSubscriptions = new ConcurrentHashMap();
    private final Map<String, Long> userForSubscriptions = new ConcurrentHashMap();

    public ReittiIntegrationService(@Value(value="${reitti.server.advertise-uri}") String advertiseUri, ReittiIntegrationJdbcService jdbcService, JdbcTemplate jdbcTemplate, RestTemplate restTemplate, AvatarService avatarService) {
        this.advertiseUri = advertiseUri;
        this.jdbcService = jdbcService;
        this.jdbcTemplate = jdbcTemplate;
        this.restTemplate = restTemplate;
        this.avatarService = avatarService;
    }

    public List<UserTimelineData> getTimelineDataRange(User user, LocalDate startDate, LocalDate endDate, ZoneId userTimezone) {
        return this.jdbcService.findAllByUser(user).stream().filter(integration -> integration.isEnabled() && VALID_INTEGRATION_STATUS.contains(integration.getStatus())).map(integration -> {
            log.debug("Fetching user timeline data range for [{}] from {} to {}", new Object[]{integration, startDate, endDate});
            try {
                RemoteUser remoteUser = this.handleRemoteUser(integration);
                List timelineEntries = this.loadTimeLineEntriesRange(integration, startDate, endDate, userTimezone);
                integration = this.update(integration.withStatus(ReittiIntegration.Status.ACTIVE).withLastUsed(LocalDateTime.now()));
                return new UserTimelineData("remote:" + integration.getId(), remoteUser.getDisplayName(), this.avatarService.generateInitials(remoteUser.getDisplayName()), "/reitti-integration/avatar/" + integration.getId(), integration.getColor(), timelineEntries, String.format("/reitti-integration/raw-location-points/%d?startDate=%s&endDate=%s&timezone=%s", integration.getId(), startDate, endDate, userTimezone), String.format("/reitti-integration/visits/%d?startDate=%s&endDate=%s&timezone=%s", integration.getId(), startDate, endDate, userTimezone));
            }
            catch (RequestFailedException e) {
                log.error("couldn't fetch user info for [{}]", integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.FAILED).withLastUsed(LocalDateTime.now()).withEnabled(false));
            }
            catch (RequestTemporaryFailedException e) {
                log.warn("couldn't temporarily fetch user info for [{}]", integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.RECOVERABLE).withLastUsed(LocalDateTime.now()));
            }
            return null;
        }).toList();
    }

    public ReittiRemoteInfo getInfo(ReittiIntegration integration) throws RequestFailedException, RequestTemporaryFailedException {
        return this.getInfo(integration.getUrl(), integration.getToken());
    }

    public ReittiRemoteInfo getInfo(String url, String token) throws RequestFailedException, RequestTemporaryFailedException {
        HttpHeaders headers = new HttpHeaders();
        headers.set("X-API-TOKEN", token);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String infoUrl = url.endsWith("/") ? url + "api/v1/reitti-integration/info" : url + "/api/v1/reitti-integration/info";
        try {
            ResponseEntity remoteResponse = this.restTemplate.exchange(infoUrl, HttpMethod.GET, entity, ReittiRemoteInfo.class, new Object[0]);
            if (remoteResponse.getStatusCode().is2xxSuccessful() && remoteResponse.getBody() != null) {
                return (ReittiRemoteInfo)remoteResponse.getBody();
            }
            if (remoteResponse.getStatusCode().is4xxClientError()) {
                throw new RequestFailedException(infoUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
            }
            throw new RequestTemporaryFailedException(infoUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
        }
        catch (RestClientException ex) {
            throw new RequestFailedException(infoUrl, HttpStatusCode.valueOf((int)500), (Object)"Connection refused");
        }
    }

    public Optional<AvatarService.AvatarData> getAvatar(User user, Long integrationId) {
        Map result;
        try {
            result = this.jdbcTemplate.queryForMap("SELECT mime_type, binary_data FROM remote_user_info WHERE integration_id = ?", new Object[]{integrationId});
        }
        catch (EmptyResultDataAccessException ignored) {
            return Optional.empty();
        }
        String contentType = (String)result.get("mime_type");
        byte[] imageData = (byte[])result.get("binary_data");
        return Optional.of(new AvatarService.AvatarData(contentType, imageData, -1L));
    }

    public ProcessedVisitResponse getVisits(User user, Long integrationId, String startDate, String endDate, Integer zoom, String timezone) {
        return this.jdbcService.findByIdAndUser(integrationId, user).stream().filter(integration -> integration.isEnabled() && VALID_INTEGRATION_STATUS.contains(integration.getStatus())).map(integration -> {
            log.debug("Fetching visit data for [{}]", integration);
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.set("X-API-TOKEN", integration.getToken());
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                String remoteUrl = integration.getUrl().endsWith("/") ? integration.getUrl() + "api/v1/visits?startDate={startDate}&endDate={endDate}&timezone={timezone}&zoom={zoom}" : integration.getUrl() + "/api/v1/visits?startDate={startDate}&endDate={endDate}&timezone={timezone}&zoom={zoom}";
                ResponseEntity remoteResponse = this.restTemplate.exchange(remoteUrl, HttpMethod.GET, entity, Map.class, new Object[]{startDate, endDate, timezone, zoom});
                if (remoteResponse.getStatusCode().is2xxSuccessful() && remoteResponse.getBody() != null) {
                    this.update(integration.withStatus(ReittiIntegration.Status.ACTIVE).withLastUsed(LocalDateTime.now()));
                    return this.parseVisitResponse((Map)remoteResponse.getBody());
                }
                if (remoteResponse.getStatusCode().is4xxClientError()) {
                    throw new RequestFailedException(remoteUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
                }
                throw new RequestTemporaryFailedException(remoteUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
            }
            catch (RequestFailedException e) {
                log.error("couldn't fetch user info for [{}]", integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.FAILED).withLastUsed(LocalDateTime.now()).withEnabled(false));
            }
            catch (RequestTemporaryFailedException e) {
                log.warn("couldn't temporarily fetch user info for [{}]", integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.RECOVERABLE).withLastUsed(LocalDateTime.now()));
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Optional<LocationPoint> findLatest(User user, Long integrationId) {
        return this.jdbcService.findByIdAndUser(integrationId, user).filter(integration -> integration.isEnabled() && VALID_INTEGRATION_STATUS.contains(integration.getStatus())).map(integration -> {
            log.debug("Fetching latest location ata for [{}]", integration);
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.set("X-API-TOKEN", integration.getToken());
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                String rawLocationDataUrl = integration.getUrl().endsWith("/") ? integration.getUrl() + "api/v1/latest-location" : integration.getUrl() + "/api/v1/latest-location";
                ResponseEntity remoteResponse = this.restTemplate.exchange(rawLocationDataUrl, HttpMethod.GET, entity, Map.class, new Object[0]);
                if (remoteResponse.getStatusCode().is2xxSuccessful() && remoteResponse.getStatusCode().is2xxSuccessful() && remoteResponse.getBody() != null && ((Map)remoteResponse.getBody()).containsKey("hasLocation")) {
                    this.update(integration.withStatus(ReittiIntegration.Status.ACTIVE).withLastUsed(LocalDateTime.now()));
                    if (!((Map)remoteResponse.getBody()).get("hasLocation").equals(true)) {
                        return null;
                    }
                    return this.parseLocationPoint(((Map)remoteResponse.getBody()).get("point"));
                }
                if (remoteResponse.getStatusCode().is4xxClientError()) {
                    throw new RequestFailedException(rawLocationDataUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
                }
                throw new RequestTemporaryFailedException(rawLocationDataUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
            }
            catch (RequestFailedException e) {
                log.error("couldn't fetch user info for [{}]", integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.FAILED).withLastUsed(LocalDateTime.now()).withEnabled(false));
            }
            catch (RequestTemporaryFailedException e) {
                log.warn("couldn't temporarily fetch user info for [{}]", integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.RECOVERABLE).withLastUsed(LocalDateTime.now()));
            }
            return null;
        });
    }

    public List<LocationPoint> getRawLocationData(User user, Long integrationId, String startDate, String endDate, Integer zoom, String timezone) {
        return this.jdbcService.findByIdAndUser(integrationId, user).stream().filter(integration -> integration.isEnabled() && VALID_INTEGRATION_STATUS.contains(integration.getStatus())).map(integration -> {
            log.debug("Fetching raw location data for [{}]", integration);
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.set("X-API-TOKEN", integration.getToken());
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                String rawLocationDataUrl = integration.getUrl().endsWith("/") ? integration.getUrl() + "api/v1/raw-location-points?startDate={startDate}&endDate={endDate}&timezone={timezone}&zoom={zoom}" : integration.getUrl() + "/api/v1/raw-location-points?startDate={startDate}&endDate={endDate}&timezone={timezone}&zoom={zoom}";
                ResponseEntity remoteResponse = this.restTemplate.exchange(rawLocationDataUrl, HttpMethod.GET, entity, Map.class, new Object[]{startDate, endDate, timezone, zoom});
                if (remoteResponse.getStatusCode().is2xxSuccessful() && remoteResponse.getBody() != null && ((Map)remoteResponse.getBody()).containsKey("segments")) {
                    this.update(integration.withStatus(ReittiIntegration.Status.ACTIVE).withLastUsed(LocalDateTime.now()));
                    return (List)((Map)remoteResponse.getBody()).get("segments");
                }
                if (remoteResponse.getStatusCode().is4xxClientError()) {
                    throw new RequestFailedException(rawLocationDataUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
                }
                throw new RequestTemporaryFailedException(rawLocationDataUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
            }
            catch (RequestFailedException e) {
                log.error("couldn't fetch user info for [{}]", integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.FAILED).withLastUsed(LocalDateTime.now()).withEnabled(false));
            }
            catch (RequestTemporaryFailedException e) {
                log.warn("couldn't temporarily fetch user info for [{}]", integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.RECOVERABLE).withLastUsed(LocalDateTime.now()));
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(Collections.emptyList());
    }

    private ReittiIntegration update(ReittiIntegration integration) {
        try {
            return (ReittiIntegration)this.jdbcService.update(integration).orElseThrow();
        }
        catch (OptimisticLockException ignored) {
            log.debug("Optimistic lock has been detected for [{}]", (Object)integration);
            return integration;
        }
    }

    private List<TimelineEntry> loadTimeLineEntriesRange(ReittiIntegration integration, LocalDate startDate, LocalDate endDate, ZoneId userTimezone) throws RequestFailedException, RequestTemporaryFailedException {
        HttpHeaders headers = new HttpHeaders();
        headers.set("X-API-TOKEN", integration.getToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String timelineUrl = integration.getUrl().endsWith("/") ? integration.getUrl() + "api/v1/reitti-integration/timeline?startDate={startDate}&endDate={endDate}&timezone={timezone}" : integration.getUrl() + "/api/v1/reitti-integration/timeline?startDate={startDate}&endDate={endDate}&timezone={timezone}";
        1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity remoteResponse = this.restTemplate.exchange(timelineUrl, HttpMethod.GET, entity, (ParameterizedTypeReference)typeRef, new Object[]{startDate, endDate, userTimezone.getId()});
        if (remoteResponse.getStatusCode().is2xxSuccessful()) {
            return (List)remoteResponse.getBody();
        }
        if (remoteResponse.getStatusCode().is4xxClientError()) {
            throw new RequestFailedException(timelineUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
        }
        throw new RequestTemporaryFailedException(timelineUrl, remoteResponse.getStatusCode(), remoteResponse.getBody());
    }

    private RemoteUser handleRemoteUser(ReittiIntegration integration) throws RequestFailedException, RequestTemporaryFailedException {
        ReittiRemoteInfo info = this.getInfo(integration);
        Optional<RemoteUser> persisted = this.jdbcService.findByIntegration(integration);
        if (persisted.isEmpty() || !((RemoteUser)persisted.get()).getRemoteVersion().equals(info.userInfo().version())) {
            log.debug("Storing new RemoteUser for [{}]", (Object)integration);
            String avatarUrl = integration.getUrl().endsWith("/") ? integration.getUrl() + "avatars/" + info.userInfo().id() : integration.getUrl() + "/avatars/" + info.userInfo().id();
            try (HttpClient httpClient = HttpClient.newHttpClient();){
                HttpRequest avatarRequest = HttpRequest.newBuilder().uri(new URI(avatarUrl)).header("X-API-TOKEN", integration.getToken()).GET().build();
                HttpResponse<byte[]> avatarResponse = httpClient.send(avatarRequest, HttpResponse.BodyHandlers.ofByteArray());
                RemoteUser remoteUser = new RemoteUser(info.userInfo().id(), info.userInfo().displayName(), info.userInfo().username(), info.userInfo().version().longValue());
                if (avatarResponse.statusCode() == 200) {
                    byte[] avatarData = avatarResponse.body();
                    String mimeType = avatarResponse.headers().firstValue("Content-Type").orElse("image/jpeg");
                    log.debug("Stored avatar for remote user [{}] with MIME type [{}]", (Object)info.userInfo().id(), (Object)mimeType);
                    this.jdbcService.store(integration, remoteUser, avatarData, mimeType);
                }
                persisted = Optional.of(remoteUser);
            }
            catch (Exception e) {
                log.warn("Failed to fetch avatar for remote user [{}]", (Object)info.userInfo().id(), (Object)e);
                throw new RequestFailedException(avatarUrl, HttpStatusCode.valueOf((int)500), (Object)"");
            }
        }
        return (RemoteUser)persisted.get();
    }

    public void registerSubscriptionsForUser(User user) {
        log.info("Registering subscriptions for user: [{}]", (Object)user.getId());
        if (this.advertiseUri == null || this.advertiseUri.isEmpty()) {
            log.warn("Advertise URI is null or empty, remote updates are disabled. Consider setting 'reitti.server.advertise-uri'");
            return;
        }
        List activeIntegrations = this.getActiveIntegrationsForUser(user);
        for (ReittiIntegration integration : activeIntegrations) {
            try {
                this.registerSubscriptionOnIntegration(integration, user);
                log.debug("Successfully registered subscription for integration: [{}]", (Object)integration.getId());
            }
            catch (RequestFailedException | Exception e) {
                log.error("couldn't fetch user info for [{}]", (Object)integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.FAILED).withLastUsed(LocalDateTime.now()).withEnabled(false));
            }
            catch (RequestTemporaryFailedException e) {
                log.warn("couldn't temporarily fetch user info for [{}]", (Object)integration, (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.RECOVERABLE).withLastUsed(LocalDateTime.now()));
            }
        }
    }

    public List<ReittiIntegration> getActiveIntegrationsForUser(User user) {
        return this.jdbcService.findAllByUser(user).stream().filter(integration -> integration.isEnabled() && VALID_INTEGRATION_STATUS.contains(integration.getStatus())).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSubscriptionOnIntegration(ReittiIntegration integration, User user) throws RequestFailedException, RequestTemporaryFailedException {
        block8: {
            if (this.advertiseUri == null || this.advertiseUri.isEmpty()) {
                log.warn("No advertise URI configured, skipping subscription registration for integration: [{}]", (Object)integration.getId());
                return;
            }
            HttpHeaders headers = new HttpHeaders();
            headers.set("X-API-TOKEN", integration.getToken());
            headers.setContentType(MediaType.APPLICATION_JSON);
            SubscriptionRequest subscriptionRequest = new SubscriptionRequest();
            subscriptionRequest.setCallbackUrl(this.advertiseUri);
            HttpEntity entity = new HttpEntity((Object)subscriptionRequest, (MultiValueMap)headers);
            String subscribeUrl = integration.getUrl().endsWith("/") ? integration.getUrl() + "api/v1/reitti-integration/subscribe" : integration.getUrl() + "/api/v1/reitti-integration/subscribe";
            try {
                ResponseEntity response = this.restTemplate.exchange(subscribeUrl, HttpMethod.POST, entity, SubscriptionResponse.class, new Object[0]);
                if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                    log.debug("Successfully subscribed to integration: [{}]", (Object)integration.getId());
                    Map map = this.integrationSubscriptions;
                    synchronized (map) {
                        this.integrationSubscriptions.put(integration.getId(), ((SubscriptionResponse)response.getBody()).getSubscriptionId());
                        this.userForSubscriptions.put(((SubscriptionResponse)response.getBody()).getSubscriptionId(), user.getId());
                        break block8;
                    }
                }
                if (response.getStatusCode().is4xxClientError()) {
                    throw new RequestFailedException(subscribeUrl, response.getStatusCode(), response.getBody());
                }
                throw new RequestTemporaryFailedException(subscribeUrl, response.getStatusCode(), response.getBody());
            }
            catch (RestClientException ex) {
                throw new RequestFailedException(subscribeUrl, HttpStatusCode.valueOf((int)500), (Object)"Connection refused");
            }
        }
    }

    public void unsubscribeFromIntegrations(User user) {
        log.info("Unsubscribing from integrations for user: [{}]", (Object)user.getId());
        List activeIntegrations = this.getActiveIntegrationsForUser(user);
        for (ReittiIntegration integration : activeIntegrations) {
            String subscriptionId = (String)this.integrationSubscriptions.get(integration.getId());
            if (subscriptionId == null) continue;
            try {
                this.unsubscribeFromIntegration(integration, subscriptionId);
                this.integrationSubscriptions.remove(integration.getId());
                this.userForSubscriptions.remove(subscriptionId);
                log.debug("Successfully unsubscribed from integration: [{}]", (Object)integration.getId());
            }
            catch (RequestFailedException | Exception e) {
                log.warn("Failed to unsubscribe from integration: [{}]", (Object)integration.getId(), (Object)e);
                this.update(integration.withStatus(ReittiIntegration.Status.FAILED).withLastUsed(LocalDateTime.now()).withEnabled(false));
            }
            catch (RequestTemporaryFailedException e) {
                this.update(integration.withStatus(ReittiIntegration.Status.RECOVERABLE).withLastUsed(LocalDateTime.now()));
            }
        }
    }

    private void unsubscribeFromIntegration(ReittiIntegration integration, String subscriptionId) throws RequestFailedException, RequestTemporaryFailedException {
        HttpHeaders headers = new HttpHeaders();
        headers.set("X-API-TOKEN", integration.getToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String unsubscribeUrl = integration.getUrl().endsWith("/") ? integration.getUrl() + "api/v1/reitti-integration/subscribe/" + subscriptionId : integration.getUrl() + "/api/v1/reitti-integration/subscribe/" + subscriptionId;
        try {
            ResponseEntity response = this.restTemplate.exchange(unsubscribeUrl, HttpMethod.DELETE, entity, Void.class, new Object[0]);
            if (!response.getStatusCode().is2xxSuccessful()) {
                if (response.getStatusCode().is4xxClientError()) {
                    throw new RequestFailedException(unsubscribeUrl, response.getStatusCode(), null);
                }
                throw new RequestTemporaryFailedException(unsubscribeUrl, response.getStatusCode(), null);
            }
        }
        catch (RestClientException ex) {
            throw new RequestFailedException(unsubscribeUrl, HttpStatusCode.valueOf((int)500), (Object)"Connection refused");
        }
    }

    public Optional<Long> getUserIdForSubscription(String subscriptionId) {
        return Optional.ofNullable((Long)this.userForSubscriptions.get(subscriptionId));
    }

    private ProcessedVisitResponse parseVisitResponse(Map<String, Object> responseBody) {
        List placesData = (List)responseBody.get("places");
        if (placesData == null) {
            return new ProcessedVisitResponse(Collections.emptyList());
        }
        List<ProcessedVisitResponse.PlaceVisitSummary> places = placesData.stream().map(arg_0 -> this.parsePlaceVisitSummary(arg_0)).toList();
        return new ProcessedVisitResponse(places);
    }

    private ProcessedVisitResponse.PlaceVisitSummary parsePlaceVisitSummary(Map<String, Object> placeData) {
        Map placeInfo = (Map)placeData.get("place");
        List polygon = this.mapToPolygon(placeInfo.get("polygon"));
        PlaceInfo place = new PlaceInfo(this.getLongValue(placeInfo, "id"), (String)placeInfo.get("name"), (String)placeInfo.get("address"), (String)placeInfo.get("city"), (String)placeInfo.get("countryCode"), this.getDoubleValue(placeInfo, "lat"), this.getDoubleValue(placeInfo, "lng"), SignificantPlace.PlaceType.valueOf((String)placeInfo.get("type").toString()), polygon);
        List visitsData = (List)placeData.get("visits");
        List<ProcessedVisitResponse.VisitDetail> visits = visitsData.stream().map(visitData -> new ProcessedVisitResponse.VisitDetail(this.getLongValue(visitData, "id"), (String)visitData.get("startTime"), (String)visitData.get("endTime"), this.getLongValue(visitData, "durationSeconds").longValue())).toList();
        long totalDurationMs = this.getLongValue(placeData, "totalDurationMs");
        int visitCount = this.getIntValue(placeData, "visitCount");
        String color = "#3388ff";
        return new ProcessedVisitResponse.PlaceVisitSummary(place, visits, totalDurationMs, visitCount, color);
    }

    private List<GeoPoint> mapToPolygon(Object polygonObj) {
        if (polygonObj == null) {
            return null;
        }
        List rawList = (List)polygonObj;
        ArrayList<GeoPoint> polygon = new ArrayList<GeoPoint>(rawList.size());
        for (Map pointMap : rawList) {
            Double lat = this.getDoubleValue(pointMap, "latitude");
            Double lng = this.getDoubleValue(pointMap, "longitude");
            if (lat == null || lng == null) continue;
            polygon.add(GeoPoint.from((double)lat, (double)lng));
        }
        return polygon;
    }

    private Long getLongValue(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }

    private Double getDoubleValue(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    private Integer getIntValue(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    private LocationPoint parseLocationPoint(Object locationObj) {
        if (locationObj == null) {
            return null;
        }
        Map locationMap = (Map)locationObj;
        LocationPoint locationPoint = new LocationPoint();
        locationPoint.setLatitude(this.getDoubleValue(locationMap, "latitude"));
        locationPoint.setLongitude(this.getDoubleValue(locationMap, "longitude"));
        locationPoint.setTimestamp((String)locationMap.get("timestamp"));
        locationPoint.setAccuracyMeters(this.getDoubleValue(locationMap, "accuracyMeters"));
        if (locationMap.containsKey("elevationMeters")) {
            locationPoint.setElevationMeters(this.getDoubleValue(locationMap, "elevationMeters"));
        }
        return locationPoint;
    }
}

