/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.springframework.stereotype.Component;

@Component
public class InMemoryLogAppender
extends AppenderBase<ILoggingEvent> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private final List<String> buffer = new CopyOnWriteArrayList();
    private final List<Consumer<String>> listeners = new CopyOnWriteArrayList();
    private volatile int maxSize = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size must be positive");
        }
        InMemoryLogAppender inMemoryLogAppender = this;
        synchronized (inMemoryLogAppender) {
            this.maxSize = size;
            while (this.buffer.size() > this.maxSize) {
                this.buffer.remove(0);
            }
        }
    }

    public int getBufferSize() {
        return this.maxSize;
    }

    public List<String> getSnapshot() {
        return new ArrayList<String>(this.buffer);
    }

    public void addListener(Consumer<String> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Consumer<String> listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent event) {
        String formattedMessage = this.formatLogEvent(event);
        InMemoryLogAppender inMemoryLogAppender = this;
        synchronized (inMemoryLogAppender) {
            this.buffer.add(formattedMessage);
            while (this.buffer.size() > this.maxSize) {
                this.buffer.remove(0);
            }
        }
        for (Consumer listener : this.listeners) {
            try {
                listener.accept(formattedMessage);
            }
            catch (Exception exception) {}
        }
    }

    private String formatLogEvent(ILoggingEvent event) {
        String timestamp = Instant.ofEpochMilli(event.getTimeStamp()).atZone(ZoneId.systemDefault()).format(FORMATTER);
        return String.format("%s [%s] %s - %s%n", timestamp, event.getLevel(), event.getLoggerName(), event.getFormattedMessage());
    }
}

