/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.dedicatedcode.reitti.config.LoggingProperties;
import com.dedicatedcode.reitti.service.logging.InMemoryLogAppender;
import com.dedicatedcode.reitti.service.logging.LoggingService;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class LoggingService {
    private static final Logger log = LoggerFactory.getLogger(LoggingService.class);
    private final LoggingProperties loggingProperties;
    private final InMemoryLogAppender logAppender;
    private final List<SseEmitter> emitters = new CopyOnWriteArrayList();

    @Autowired
    public LoggingService(LoggingProperties loggingProperties, InMemoryLogAppender logAppender) {
        this.loggingProperties = loggingProperties;
        this.logAppender = logAppender;
        logAppender.setBufferSize(loggingProperties.getBufferSize());
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger rootLogger = context.getLogger("ROOT");
        logAppender.setContext((Context)context);
        logAppender.start();
        rootLogger.addAppender((Appender)logAppender);
    }

    public void setLoggerLevel(String loggerName, String level) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = context.getLogger(loggerName);
        Level logbackLevel = Level.valueOf((String)level.toUpperCase());
        logger.setLevel(logbackLevel);
    }

    public void setBufferSize(int size) {
        if (size > this.loggingProperties.getMaxBufferSize()) {
            throw new IllegalArgumentException("Buffer size cannot exceed " + this.loggingProperties.getMaxBufferSize());
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size must be positive");
        }
        this.logAppender.setBufferSize(size);
    }

    public int getCurrentBufferSize() {
        return this.logAppender.getBufferSize();
    }

    public int getMaxBufferSize() {
        return this.loggingProperties.getMaxBufferSize();
    }

    public List<String> getLogSnapshot() {
        return this.logAppender.getSnapshot();
    }

    public String getCurrentLogLevel() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger rootLogger = context.getLogger("ROOT");
        Level level = rootLogger.getLevel();
        return level != null ? level.toString() : "INFO";
    }

    public List<LoggerInfo> getAllConfiguredLoggers() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ArrayList<LoggerInfo> loggers = new ArrayList<LoggerInfo>();
        ch.qos.logback.classic.Logger rootLogger = context.getLogger("ROOT");
        Level rootLevel = rootLogger.getLevel();
        if (rootLevel != null) {
            loggers.add(new LoggerInfo("ROOT", rootLevel.toString()));
        }
        for (ch.qos.logback.classic.Logger logger : context.getLoggerList()) {
            if (logger.getLevel() == null || "ROOT".equals(logger.getName())) continue;
            loggers.add(new LoggerInfo(logger.getName(), logger.getLevel().toString()));
        }
        return loggers.stream().sorted((a, b) -> {
            if ("ROOT".equals(a.name())) {
                return -1;
            }
            if ("ROOT".equals(b.name())) {
                return 1;
            }
            return a.name().compareTo(b.name());
        }).collect(Collectors.toList());
    }

    public void removeLogger(String loggerName) {
        if ("ROOT".equals(loggerName)) {
            throw new IllegalArgumentException("Cannot remove ROOT logger");
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = context.getLogger(loggerName);
        logger.setLevel(null);
    }

    public SseEmitter createLogStream() {
        SseEmitter emitter = new SseEmitter(Long.valueOf(Long.MAX_VALUE));
        this.emitters.add(emitter);
        try {
            List snapshot = this.getLogSnapshot();
            for (String logLine2 : snapshot) {
                emitter.send(SseEmitter.event().name("log").data((Object)this.formatLogLineForHtml(logLine2)));
            }
        }
        catch (IOException e) {
            emitter.completeWithError((Throwable)e);
            return emitter;
        }
        Consumer<String> listener = logLine -> {
            try {
                emitter.send(SseEmitter.event().name("log").data((Object)this.formatLogLineForHtml(logLine)));
            }
            catch (IOException e) {
                emitter.completeWithError((Throwable)e);
            }
        };
        this.logAppender.addListener(listener);
        emitter.onCompletion(() -> {
            this.emitters.remove(emitter);
            this.logAppender.removeListener(listener);
        });
        emitter.onTimeout(() -> {
            this.emitters.remove(emitter);
            this.logAppender.removeListener(listener);
        });
        emitter.onError(ignored -> {
            this.emitters.remove(emitter);
            this.logAppender.removeListener(listener);
        });
        return emitter;
    }

    @PreDestroy
    public void cleanup() {
        System.out.println("Closing SSE emitters");
        for (SseEmitter emitter : this.emitters) {
            try {
                emitter.complete();
            }
            catch (Exception exception) {}
        }
        this.emitters.clear();
    }

    private String formatLogLineForHtml(String logLine) {
        String escaped = logLine.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
        return "<div class=\"log-line\">" + escaped + "</div>";
    }
}

