/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.processing;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import com.dedicatedcode.reitti.service.UserNotificationService;
import com.dedicatedcode.reitti.service.processing.GeoPointAnomalyFilter;
import com.dedicatedcode.reitti.service.processing.LocationDataDensityNormalizer;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationDataIngestPipeline {
    private static final Logger logger = LoggerFactory.getLogger(LocationDataIngestPipeline.class);
    private final GeoPointAnomalyFilter geoPointAnomalyFilter;
    private final UserJdbcService userJdbcService;
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final UserNotificationService userNotificationService;
    private final LocationDataDensityNormalizer densityNormalizer;

    @Autowired
    public LocationDataIngestPipeline(GeoPointAnomalyFilter geoPointAnomalyFilter, UserJdbcService userJdbcService, RawLocationPointJdbcService rawLocationPointJdbcService, UserSettingsJdbcService userSettingsJdbcService, UserNotificationService userNotificationService, LocationDataDensityNormalizer densityNormalizer) {
        this.geoPointAnomalyFilter = geoPointAnomalyFilter;
        this.userJdbcService = userJdbcService;
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.userNotificationService = userNotificationService;
        this.densityNormalizer = densityNormalizer;
    }

    @PreDestroy
    public void shutdown() {
    }

    public void processLocationData(String username, List<LocationPoint> points) {
        try {
            long start = System.currentTimeMillis();
            logger.debug("starting processing");
            Optional userOpt = this.userJdbcService.findByUsername(username);
            if (userOpt.isEmpty()) {
                logger.warn("User not found for name: [{}]", (Object)username);
                return;
            }
            User user = (User)userOpt.get();
            List filtered = this.geoPointAnomalyFilter.filterAnomalies(points);
            int updatedRows = this.rawLocationPointJdbcService.bulkInsert(user, filtered);
            this.densityNormalizer.normalize(user, filtered);
            this.userSettingsJdbcService.updateNewestData(user, filtered);
            this.userNotificationService.newRawLocationData(user, filtered);
            logger.info("Finished storing and normalizing points [{}] for user [{}] in [{}]ms. Filtered out [{}] points before database and [{}] after database.", new Object[]{filtered.size(), user, System.currentTimeMillis() - start, points.size() - filtered.size(), filtered.size() - updatedRows});
        }
        catch (Exception e) {
            logger.error("Error during processing: ", (Throwable)e);
        }
    }
}

