/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.service.processing;

import com.dedicatedcode.reitti.model.geo.GeoUtils;
import com.dedicatedcode.reitti.model.geo.RawLocationPoint;
import com.dedicatedcode.reitti.model.geo.TransportMode;
import com.dedicatedcode.reitti.model.geo.TransportModeConfig;
import com.dedicatedcode.reitti.model.geo.Trip;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.TransportModeJdbcService;
import com.dedicatedcode.reitti.repository.TransportModeOverrideJdbcService;
import com.dedicatedcode.reitti.service.processing.TransportModeService;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class TransportModeService {
    private final TransportModeJdbcService transportModeJdbcService;
    private final TransportModeOverrideJdbcService transportModeOverrideJdbcService;

    public TransportModeService(TransportModeJdbcService transportModeJdbcService, TransportModeOverrideJdbcService transportModeOverrideJdbcService) {
        this.transportModeJdbcService = transportModeJdbcService;
        this.transportModeOverrideJdbcService = transportModeOverrideJdbcService;
    }

    public TransportMode inferTransportMode(User user, List<RawLocationPoint> tripPoints, Instant startTime, Instant endTime) {
        Optional override = this.transportModeOverrideJdbcService.getTransportModeOverride(user, startTime, endTime);
        if (override.isPresent()) {
            return (TransportMode)override.get();
        }
        List config = this.transportModeJdbcService.getTransportModeConfigs(user);
        return this.segmentAndClassifyTrip(tripPoints, config);
    }

    public void overrideTransportMode(User user, TransportMode transportMode, Trip trip) {
        this.transportModeOverrideJdbcService.addTransportModeOverride(user, transportMode, trip.getStartTime(), trip.getEndTime());
    }

    public TransportMode segmentAndClassifyTrip(List<RawLocationPoint> points, List<TransportModeConfig> configs) {
        ArrayList<TripSegment> segments = new ArrayList<TripSegment>();
        List speeds = this.calculateSpeeds(points);
        ArrayList<RawLocationPoint> currentSegmentPoints = new ArrayList<RawLocationPoint>();
        currentSegmentPoints.add(points.getFirst());
        for (int i = 1; i < points.size(); ++i) {
            double prevSpeed = i > 1 ? (Double)speeds.get(i - 2) : 0.0;
            double currSpeed = (Double)speeds.get(i - 1);
            if (prevSpeed > 0.0 && Math.abs(currSpeed - prevSpeed) / prevSpeed > 0.5) {
                TransportMode mode = this.classifySegment(currentSegmentPoints, configs);
                segments.add(new TripSegment(new ArrayList(currentSegmentPoints), mode));
                currentSegmentPoints.clear();
            }
            currentSegmentPoints.add(points.get(i));
        }
        TransportMode mode = this.classifySegment(currentSegmentPoints, configs);
        segments.add(new TripSegment(currentSegmentPoints, mode));
        HashMap<TransportMode, Double> modeDurationMinutes = new HashMap<TransportMode, Double>();
        for (TripSegment segment : segments) {
            if (segment.points().size() < 2) continue;
            Instant startTime = ((RawLocationPoint)segment.points().getFirst()).getTimestamp();
            Instant endTime = ((RawLocationPoint)segment.points().getLast()).getTimestamp();
            double durationMinutes = (double)Duration.between(startTime, endTime).toMillis() / 60000.0;
            modeDurationMinutes.merge(segment.dominantMode(), durationMinutes, Double::sum);
        }
        return modeDurationMinutes.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(TransportMode.UNKNOWN);
    }

    private List<Double> calculateSpeeds(List<RawLocationPoint> points) {
        ArrayList<Double> speeds = new ArrayList<Double>();
        for (int i = 1; i < points.size(); ++i) {
            double distanceKm = GeoUtils.distanceInMeters((RawLocationPoint)points.get(i - 1), (RawLocationPoint)points.get(i)) / 1000.0;
            Duration timeDiff = Duration.between(points.get(i - 1).getTimestamp(), points.get(i).getTimestamp());
            double timeHours = (double)timeDiff.toMillis() / 3600000.0;
            double speedKmH = timeHours > 0.0 ? distanceKm / timeHours : 0.0;
            speeds.add(speedKmH);
        }
        return speeds;
    }

    private TransportMode classifySegment(List<RawLocationPoint> segmentPoints, List<TransportModeConfig> configs) {
        List speeds = this.calculateSpeeds(segmentPoints);
        double avgSpeed = speeds.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        for (TransportModeConfig transportModeConfig : configs) {
            if (transportModeConfig.maxKmh() != null && !(transportModeConfig.maxKmh() > avgSpeed)) continue;
            return transportModeConfig.mode();
        }
        return TransportMode.UNKNOWN;
    }
}

