/*
 * Decompiled with CFR 0.152.
 */
package db.migration;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class V42__Clear_default_admin_password
extends BaseJavaMigration {
    public void migrate(Context context) throws Exception {
        String selectSql = "SELECT id, password FROM users WHERE role = 'ADMIN'";
        try (PreparedStatement selectStmt = context.getConnection().prepareStatement(selectSql);
             ResultSet rs = selectStmt.executeQuery();){
            BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
            while (rs.next()) {
                Long userId = rs.getLong("id");
                String currentPassword = rs.getString("password");
                if (currentPassword == null || !encoder.matches((CharSequence)"admin", currentPassword)) continue;
                String updateSql = "UPDATE users SET password = NULL WHERE id = ?";
                PreparedStatement updateStmt = context.getConnection().prepareStatement(updateSql);
                try {
                    updateStmt.setLong(1, userId);
                    updateStmt.executeUpdate();
                }
                finally {
                    if (updateStmt == null) continue;
                    updateStmt.close();
                }
            }
        }
    }
}

