CREATE TABLE visit_detection_parameters (
    id BIGINT GENERATED BY DEFAULT AS IDENTITY,
    user_id BIGINT REFERENCES users(id) ON DELETE CASCADE,
    valid_since TIMESTAMP NULL,
    detection_search_distance_meters BIGINT NOT NULL,
    detection_minimum_adjacent_points BIGINT NOT NULL,
    detection_minimum_stay_time_seconds BIGINT NOT NULL,
    detection_max_merge_time_between_same_stay_points BIGINT NOT NULL,
    merging_search_duration_in_hours BIGINT NOT NULL,
    merging_max_merge_time_between_same_visits BIGINT NOT NULL ,
    merging_min_distance_between_visits BIGINT NOT NULL,
    CONSTRAINT user_valid_since_pk UNIQUE (user_id, valid_since)
);

INSERT INTO visit_detection_parameters(user_id, valid_since, detection_search_distance_meters, detection_minimum_adjacent_points, detection_minimum_stay_time_seconds, detection_max_merge_time_between_same_stay_points, merging_search_duration_in_hours, merging_max_merge_time_between_same_visits, merging_min_distance_between_visits)
SELECT id,
       NULL,
       100,
       5,
       300,
       300,
       48,
       300,
       200
   FROM users;