create table preview_significant_places
(
    id                 bigint generated by default as identity primary key,
    address            varchar(255),
    latitude_centroid  double precision                               not null,
    longitude_centroid double precision                               not null,
    name               varchar(255),
    user_id            bigint                                         not null references users (id) ON DELETE CASCADE,
    geom               geometry,
    geocoded           boolean     default false                      not null,
    version            bigint      default 0                          not null,
    type               varchar(50) default 'OTHER'::character varying not null,
    country_code       varchar(10),
    timezone           text,
    city               varchar(255),
    preview_id         VARCHAR(36)                                    NOT NULL DEFAULT '',
    preview_created_at TIMESTAMP   DEFAULT now()
);

