/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirror;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Assertions;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LoaderUtils;
import org.apache.tools.ant.util.SplitClassLoader;

public class JUnitTask
extends Task {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String CLASSPATH = "CLASSPATH";
    private CommandlineJava commandline;
    private Vector tests = new Vector();
    private Vector batchTests = new Vector();
    private Vector formatters = new Vector();
    private File dir = null;
    private Integer timeout = null;
    private boolean summary = false;
    private boolean reloading = true;
    private String summaryValue = "";
    private JUnitTaskMirror.JUnitTestRunnerMirror runner = null;
    private boolean newEnvironment = false;
    private Environment env = new Environment();
    private boolean includeAntRuntime = true;
    private Path antRuntimeClasses = null;
    private boolean showOutput = false;
    private boolean outputToFormatters = true;
    private boolean logFailedTests = true;
    private File tmpDir;
    private AntClassLoader classLoader = null;
    private Permissions perm = null;
    private ForkMode forkMode = new ForkMode("perTest");
    private boolean splitJunit = false;
    private boolean enableTestListenerEvents = false;
    private JUnitTaskMirror delegate;
    private ClassLoader mirrorLoader;
    private boolean forkedPathChecked = false;
    private boolean haltOnError = false;
    private boolean haltOnFail = false;
    private boolean filterTrace = true;
    private boolean fork = false;
    private String failureProperty;
    private String errorProperty;
    private static final int STRING_BUFFER_SIZE = 128;
    public static final String TESTLISTENER_PREFIX = "junit.framework.TestListener: ";
    public static final String ENABLE_TESTLISTENER_EVENTS = "ant.junit.enabletestlistenerevents";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    static final String TIMEOUT_MESSAGE = "Timeout occurred. Please note the time in the report does not reflect the time until the timeout.";
    static final String NAME_OF_DUMMY_TEST = "Batch-With-Multiple-Tests";
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$optional$junit$JUnitTask$ForkedTestConfiguration;

    public void setReloading(boolean value) {
        this.reloading = value;
    }

    public void setFiltertrace(boolean value) {
        this.filterTrace = value;
    }

    public void setHaltonerror(boolean value) {
        this.haltOnError = value;
    }

    public void setErrorProperty(String propertyName) {
        this.errorProperty = propertyName;
    }

    public void setHaltonfailure(boolean value) {
        this.haltOnFail = value;
    }

    public void setFailureProperty(String propertyName) {
        this.failureProperty = propertyName;
    }

    public void setFork(boolean value) {
        this.fork = value;
    }

    public void setForkMode(ForkMode mode) {
        this.forkMode = mode;
    }

    public void setPrintsummary(SummaryAttribute value) {
        this.summaryValue = value.getValue();
        this.summary = value.asBoolean();
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    public void setMaxmemory(String max) {
        this.getCommandline().setMaxmemory(max);
    }

    public void setJvm(String value) {
        this.getCommandline().setVm(value);
    }

    public Commandline.Argument createJvmarg() {
        return this.getCommandline().createVmArgument();
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.getCommandline().addSysproperty(sysp);
    }

    public void addConfiguredSysproperty(Environment.Variable sysp) {
        String testString = sysp.getContent();
        this.getProject().log("sysproperty added : " + testString, 4);
        this.getCommandline().addSysproperty(sysp);
    }

    public void addSyspropertyset(PropertySet sysp) {
        this.getCommandline().addSyspropertyset(sysp);
    }

    public Path createClasspath() {
        return this.getCommandline().createClasspath(this.getProject()).createPath();
    }

    public Path createBootclasspath() {
        return this.getCommandline().createBootclasspath(this.getProject()).createPath();
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    private void preConfigure(BaseTest test) {
        test.setFiltertrace(this.filterTrace);
        test.setHaltonerror(this.haltOnError);
        if (this.errorProperty != null) {
            test.setErrorProperty(this.errorProperty);
        }
        test.setHaltonfailure(this.haltOnFail);
        if (this.failureProperty != null) {
            test.setFailureProperty(this.failureProperty);
        }
        test.setFork(this.fork);
    }

    public void addTest(JUnitTest test) {
        this.tests.addElement(test);
        this.preConfigure(test);
    }

    public BatchTest createBatchTest() {
        BatchTest test = new BatchTest(this.getProject());
        this.batchTests.addElement(test);
        this.preConfigure(test);
        return test;
    }

    public void addFormatter(FormatterElement fe) {
        this.formatters.addElement(fe);
    }

    public void setIncludeantruntime(boolean b) {
        this.includeAntRuntime = b;
    }

    public void setShowOutput(boolean showOutput) {
        this.showOutput = showOutput;
    }

    public void setOutputToFormatters(boolean outputToFormatters) {
        this.outputToFormatters = outputToFormatters;
    }

    public void setLogFailedTests(boolean logFailedTests) {
        this.logFailedTests = logFailedTests;
    }

    public void addAssertions(Assertions asserts) {
        if (this.getCommandline().getAssertions() != null) {
            throw new BuildException("Only one assertion declaration is allowed");
        }
        this.getCommandline().setAssertions(asserts);
    }

    public Permissions createPermissions() {
        if (this.perm == null) {
            this.perm = new Permissions();
        }
        return this.perm;
    }

    public void setCloneVm(boolean cloneVm) {
        this.getCommandline().setCloneVm(cloneVm);
    }

    public void setTempdir(File tmpDir) {
        if (!(tmpDir == null || tmpDir.exists() && tmpDir.isDirectory())) {
            throw new BuildException(tmpDir.toString() + " is not a valid temp directory");
        }
        this.tmpDir = tmpDir;
    }

    public void setEnableTestListenerEvents(boolean b) {
        this.enableTestListenerEvents = b;
    }

    public boolean getEnableTestListenerEvents() {
        String e = this.getProject().getProperty(ENABLE_TESTLISTENER_EVENTS);
        if (e != null) {
            return Project.toBoolean((String)e);
        }
        return this.enableTestListenerEvents;
    }

    public void init() {
        this.antRuntimeClasses = new Path(this.getProject());
        this.splitJunit = !this.addClasspathResource("/junit/framework/TestCase.class");
        this.addClasspathEntry("/org/apache/tools/ant/launch/AntMain.class");
        this.addClasspathEntry("/org/apache/tools/ant/Task.class");
        this.addClasspathEntry("/org/apache/tools/ant/taskdefs/optional/junit/JUnitTestRunner.class");
        this.addClasspathEntry("/org/apache/tools/ant/taskdefs/optional/junit/JUnit4TestMethodAdapter.class");
    }

    private static JUnitTaskMirror createMirror(JUnitTask task, ClassLoader loader) {
        try {
            loader.loadClass("junit.framework.Test");
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("The <classpath> for <junit> must include junit.jar if not in Ant's own classpath", (Throwable)e, task.getLocation());
        }
        try {
            Class<?> c = loader.loadClass(JUnitTaskMirror.class.getName() + "Impl");
            if (c.getClassLoader() != loader) {
                throw new BuildException("Overdelegating loader", task.getLocation());
            }
            Constructor<?> cons = c.getConstructor(JUnitTask.class);
            return (JUnitTaskMirror)cons.newInstance(new Object[]{task});
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, task.getLocation());
        }
    }

    protected void setupJUnitDelegate() {
        final ClassLoader myLoader = JUnitTask.class.getClassLoader();
        if (this.splitJunit) {
            final Path path = new Path(this.getProject());
            path.add(this.antRuntimeClasses);
            Path extra = this.getCommandline().getClasspath();
            if (extra != null) {
                path.add(extra);
            }
            this.mirrorLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new SplitClassLoader(myLoader, path, JUnitTask.this.getProject(), new String[]{"BriefJUnitResultFormatter", "JUnit4TestMethodAdapter", "JUnitResultFormatter", "JUnitTaskMirrorImpl", "JUnitTestRunner", "JUnitVersionHelper", "OutErrSummaryJUnitResultFormatter", "PlainJUnitResultFormatter", "SummaryJUnitResultFormatter", "TearDownOnVmCrash", "XMLJUnitResultFormatter"});
                }
            });
        } else {
            this.mirrorLoader = myLoader;
        }
        this.delegate = JUnitTask.createMirror(this, this.mirrorLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.checkMethodLists();
        this.setupJUnitDelegate();
        ArrayList testLists = new ArrayList();
        boolean forkPerTest = this.forkMode.getValue().equals("perTest");
        if (forkPerTest || this.forkMode.getValue().equals("once")) {
            testLists.addAll(this.executeOrQueue(this.getIndividualTests(), forkPerTest));
        } else {
            int count = this.batchTests.size();
            for (int i = 0; i < count; ++i) {
                BatchTest batchtest = (BatchTest)this.batchTests.elementAt(i);
                testLists.addAll(this.executeOrQueue(batchtest.elements(), false));
            }
            testLists.addAll(this.executeOrQueue(this.tests.elements(), forkPerTest));
        }
        try {
            Iterator iter = testLists.iterator();
            while (iter.hasNext()) {
                List l = (List)iter.next();
                if (l.size() == 1) {
                    this.execute((JUnitTest)l.get(0));
                    continue;
                }
                this.execute(l);
            }
            Object var7_8 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.cleanup();
            throw throwable;
        }
    }

    protected void execute(JUnitTest arg) throws BuildException {
        this.validateTestName(arg.getName());
        JUnitTest test = (JUnitTest)arg.clone();
        if (test.getTodir() == null) {
            test.setTodir(this.getProject().resolveFile("."));
        }
        if (test.getOutfile() == null) {
            test.setOutfile("TEST-" + test.getName());
        }
        TestResultHolder result = null;
        if (!test.getFork()) {
            result = this.executeInVM(test);
        } else {
            ExecuteWatchdog watchdog = this.createWatchdog();
            result = this.executeAsForked(test, watchdog, null);
        }
        this.actOnTestResult(result, test, "Test " + test.getName());
    }

    private void validateTestName(String testName) throws BuildException {
        if (testName == null || testName.length() == 0 || testName.equals("null")) {
            throw new BuildException("test name must be specified");
        }
    }

    /*
     * Loose catch block
     */
    protected void execute(List testList) throws BuildException {
        block12: {
            JUnitTest test = null;
            File casesFile = this.createTempPropertiesFile("junittestcases");
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(casesFile));
            this.log("Creating casesfile '" + casesFile.getAbsolutePath() + "' with content: ", 3);
            PrintStream logWriter = new PrintStream((OutputStream)new LogOutputStream((Task)this, 3));
            Iterator iter = testList.iterator();
            while (iter.hasNext()) {
                test = (JUnitTest)iter.next();
                JUnitTask.printDual(writer, logWriter, test.getName());
                if (test.getMethods() != null) {
                    JUnitTask.printDual(writer, logWriter, ":" + test.getMethodsString().replace(',', '+'));
                }
                if (test.getTodir() == null) {
                    JUnitTask.printDual(writer, logWriter, "," + this.getProject().resolveFile("."));
                } else {
                    JUnitTask.printDual(writer, logWriter, "," + test.getTodir());
                }
                if (test.getOutfile() == null) {
                    JUnitTask.printlnDual(writer, logWriter, ",TEST-" + test.getName());
                    continue;
                }
                JUnitTask.printlnDual(writer, logWriter, "," + test.getOutfile());
            }
            writer.flush();
            writer.close();
            writer = null;
            ExecuteWatchdog watchdog = this.createWatchdog();
            TestResultHolder result = this.executeAsForked(test, watchdog, casesFile);
            this.actOnTestResult(result, test, "Tests");
            Object var10_10 = null;
            FileUtils.close((Writer)writer);
            try {
                FILE_UTILS.tryHardToDelete(casesFile);
            }
            catch (Exception e) {
                this.log(e.toString(), 0);
            }
            break block12;
            {
                catch (IOException e) {
                    this.log(e.toString(), 0);
                    throw new BuildException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                FileUtils.close(writer);
                try {
                    FILE_UTILS.tryHardToDelete(casesFile);
                }
                catch (Exception e) {
                    this.log(e.toString(), 0);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TestResultHolder executeAsForked(JUnitTest test, ExecuteWatchdog watchdog, File casesFile) throws BuildException {
        boolean crash2;
        String vmCrashString2;
        TestResultHolder result;
        File propsFile;
        FormatterElement[] feArray;
        block48: {
            BufferedReader br2;
            String[] environment;
            CommandlineJava cmd;
            if (this.perm != null) {
                this.log("Permissions ignored when running in forked mode!", 1);
            }
            try {
                cmd = (CommandlineJava)this.getCommandline().clone();
            }
            catch (CloneNotSupportedException e) {
                throw new BuildException("This shouldn't happen", (Throwable)e, this.getLocation());
            }
            if (casesFile == null) {
                cmd.createArgument().setValue(test.getName());
                if (test.getMethods() != null) {
                    cmd.createArgument().setValue("methods=" + test.getMethodsString());
                }
            } else {
                this.log("Running multiple tests in the same VM", 3);
                cmd.createArgument().setValue("testsfile=" + casesFile);
            }
            cmd.createArgument().setValue("filtertrace=" + test.getFiltertrace());
            cmd.createArgument().setValue("haltOnError=" + test.getHaltonerror());
            cmd.createArgument().setValue("haltOnFailure=" + test.getHaltonfailure());
            this.checkIncludeAntRuntime(cmd);
            this.checkIncludeSummary(cmd);
            cmd.createArgument().setValue("showoutput=" + String.valueOf(this.showOutput));
            cmd.createArgument().setValue("outputtoformatters=" + String.valueOf(this.outputToFormatters));
            cmd.createArgument().setValue("logfailedtests=" + String.valueOf(this.logFailedTests));
            cmd.createArgument().setValue("logtestlistenerevents=" + String.valueOf(this.getEnableTestListenerEvents()));
            StringBuffer formatterArg = new StringBuffer(128);
            feArray = this.mergeFormatters(test);
            for (int i = 0; i < feArray.length; ++i) {
                FormatterElement fe = feArray[i];
                if (!fe.shouldUse(this)) continue;
                formatterArg.append("formatter=");
                formatterArg.append(fe.getClassname());
                File outFile = this.getOutput(fe, test);
                if (outFile != null) {
                    formatterArg.append(",");
                    formatterArg.append(outFile);
                }
                cmd.createArgument().setValue(formatterArg.toString());
                formatterArg = new StringBuffer();
            }
            File vmWatcher = this.createTempPropertiesFile("junitvmwatcher");
            cmd.createArgument().setValue("crashfile=" + vmWatcher.getAbsolutePath());
            propsFile = this.createTempPropertiesFile("junit");
            cmd.createArgument().setValue("propsfile=" + propsFile.getAbsolutePath());
            Hashtable p = this.getProject().getProperties();
            Properties props = new Properties();
            Enumeration e = p.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                props.put(key, p.get(key));
            }
            try {
                FileOutputStream outstream = new FileOutputStream(propsFile);
                props.store(outstream, "Ant JUnitTask generated properties file");
                outstream.close();
            }
            catch (IOException e2) {
                FILE_UTILS.tryHardToDelete(propsFile);
                throw new BuildException("Error creating temporary properties file.", (Throwable)e2, this.getLocation());
            }
            Execute execute = new Execute((ExecuteStreamHandler)new JUnitLogStreamHandler(this, 2, 1), watchdog);
            execute.setCommandline(cmd.getCommandline());
            execute.setAntRun(this.getProject());
            if (this.dir != null) {
                execute.setWorkingDirectory(this.dir);
            }
            if ((environment = this.env.getVariables()) != null) {
                for (int i = 0; i < environment.length; ++i) {
                    this.log("Setting environment variable: " + environment[i], 3);
                }
            }
            execute.setNewenvironment(this.newEnvironment);
            execute.setEnvironment(environment);
            this.log(cmd.describeCommand(), 3);
            this.checkForkedPath(cmd);
            result = new TestResultHolder();
            try {
                try {
                    result.exitCode = execute.execute();
                }
                catch (IOException e3) {
                    throw new BuildException("Process fork failed.", (Throwable)e3, this.getLocation());
                }
                Object var16_18 = null;
                vmCrashString2 = "unknown";
                br2 = null;
            }
            catch (Throwable throwable) {
                boolean crash2;
                String vmCrashString2;
                block45: {
                    Object var16_19 = null;
                    vmCrashString2 = "unknown";
                    BufferedReader br2 = null;
                    try {
                        try {
                            if (vmWatcher.exists()) {
                                br2 = new BufferedReader(new FileReader(vmWatcher));
                                vmCrashString2 = br2.readLine();
                            } else {
                                vmCrashString2 = "Monitor file (" + vmWatcher.getAbsolutePath() + ") missing, location not writable," + " testcase not started or mixing ant versions?";
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            Object var21_28 = null;
                            FileUtils.close(br2);
                            if (vmWatcher.exists()) {
                                FILE_UTILS.tryHardToDelete(vmWatcher);
                            }
                            break block45;
                        }
                        Object var21_27 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var21_29 = null;
                        FileUtils.close(br2);
                        if (vmWatcher.exists()) {
                            FILE_UTILS.tryHardToDelete(vmWatcher);
                        }
                        throw throwable2;
                    }
                    FileUtils.close((Reader)br2);
                    if (vmWatcher.exists()) {
                        FILE_UTILS.tryHardToDelete(vmWatcher);
                    }
                }
                boolean bl = crash2 = watchdog != null && watchdog.killedProcess() || !"terminated successfully".equals(vmCrashString2);
                if (casesFile != null && crash2) {
                    test = JUnitTask.createDummyTestForBatchTest(test);
                }
                if (watchdog != null && watchdog.killedProcess()) {
                    result.timedOut = true;
                    this.logTimeout(feArray, test, vmCrashString2);
                } else if (crash2) {
                    result.crashed = true;
                    this.logVmCrash(feArray, test, vmCrashString2);
                }
                if (!FILE_UTILS.tryHardToDelete(propsFile)) {
                    throw new BuildException("Could not delete temporary properties file '" + propsFile.getAbsolutePath() + "'.");
                }
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                Object var21_26 = null;
                FileUtils.close(br2);
                if (vmWatcher.exists()) {
                    FILE_UTILS.tryHardToDelete(vmWatcher);
                }
                throw throwable;
            }
            try {}
            catch (Exception e2) {
                e2.printStackTrace();
                Object var21_25 = null;
                FileUtils.close(br2);
                if (vmWatcher.exists()) {
                    FILE_UTILS.tryHardToDelete(vmWatcher);
                }
                break block48;
            }
            if (vmWatcher.exists()) {
                br2 = new BufferedReader(new FileReader(vmWatcher));
                vmCrashString2 = br2.readLine();
            } else {
                vmCrashString2 = "Monitor file (" + vmWatcher.getAbsolutePath() + ") missing, location not writable," + " testcase not started or mixing ant versions?";
            }
            Object var21_24 = null;
            FileUtils.close((Reader)br2);
            if (vmWatcher.exists()) {
                FILE_UTILS.tryHardToDelete(vmWatcher);
            }
        }
        boolean bl = crash2 = watchdog != null && watchdog.killedProcess() || !"terminated successfully".equals(vmCrashString2);
        if (casesFile != null && crash2) {
            test = JUnitTask.createDummyTestForBatchTest(test);
        }
        if (watchdog != null && watchdog.killedProcess()) {
            result.timedOut = true;
            this.logTimeout(feArray, test, vmCrashString2);
        } else if (crash2) {
            result.crashed = true;
            this.logVmCrash(feArray, test, vmCrashString2);
        }
        if (!FILE_UTILS.tryHardToDelete(propsFile)) {
            throw new BuildException("Could not delete temporary properties file '" + propsFile.getAbsolutePath() + "'.");
        }
        return result;
    }

    private void checkIncludeAntRuntime(CommandlineJava cmd) {
        if (this.includeAntRuntime) {
            Map env = Execute.getEnvironmentVariables();
            String cp = (String)env.get(CLASSPATH);
            if (cp != null) {
                cmd.createClasspath(this.getProject()).createPath().append(new Path(this.getProject(), cp));
            }
            this.log("Implicitly adding " + this.antRuntimeClasses + " to CLASSPATH", 3);
            cmd.createClasspath(this.getProject()).createPath().append(this.antRuntimeClasses);
        }
    }

    private boolean equalsWithOutAndErr(String summaryOption) {
        return "withoutanderr".equalsIgnoreCase(summaryOption);
    }

    private void checkIncludeSummary(CommandlineJava cmd) {
        if (this.summary) {
            String prefix = "";
            if (this.equalsWithOutAndErr(this.summaryValue)) {
                prefix = "OutErr";
            }
            cmd.createArgument().setValue("formatter=org.apache.tools.ant.taskdefs.optional.junit." + prefix + "SummaryJUnitResultFormatter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForkedPath(CommandlineJava cmd) {
        if (this.forkedPathChecked) {
            return;
        }
        this.forkedPathChecked = true;
        if (!cmd.haveClasspath()) {
            return;
        }
        loader = null;
        try {
            block10: {
                block9: {
                    loader = AntClassLoader.newAntClassLoader(null, (Project)this.getProject(), (Path)cmd.createClasspath(this.getProject()), (boolean)true);
                    projectResourceName = LoaderUtils.classNameToResource((String)Project.class.getName());
                    previous = null;
                    try {
                        e = loader.getResources(projectResourceName);
lbl13:
                        // 2 sources

                        while (e.hasMoreElements()) {
                            current = (URL)e.nextElement();
                            if (previous != null && !JUnitTask.urlEquals(current, previous)) {
                                this.log("WARNING: multiple versions of ant detected in path for junit " + JUnitTask.LINE_SEP + "         " + previous + JUnitTask.LINE_SEP + "     and " + current, 1);
                                break block9;
                            }
                            ** GOTO lbl-1000
                        }
                        break block10;
                    }
                    catch (Exception ex) {
                        break block10;
                    }
                }
                var8_8 = null;
                if (loader == null) return;
                loader.cleanup();
                return;
lbl-1000:
                // 1 sources

                {
                    previous = current;
                    ** GOTO lbl13
                }
            }
            var8_9 = null;
            if (loader == null) return;
            loader.cleanup();
            return;
        }
        catch (Throwable var7_11) {
            var8_10 = null;
            if (loader == null) throw var7_11;
            loader.cleanup();
            throw var7_11;
        }
    }

    private static boolean urlEquals(URL u1, URL u2) {
        String url1 = JUnitTask.maybeStripJarAndClass(u1);
        String url2 = JUnitTask.maybeStripJarAndClass(u2);
        if (url1.startsWith("file:") && url2.startsWith("file:")) {
            return new File(FILE_UTILS.fromURI(url1)).equals(new File(FILE_UTILS.fromURI(url2)));
        }
        return url1.equals(url2);
    }

    private static String maybeStripJarAndClass(URL u) {
        String s = u.toString();
        if (s.startsWith("jar:")) {
            int pling = s.indexOf(33);
            s = s.substring(4, pling == -1 ? s.length() : pling);
        }
        return s;
    }

    private File createTempPropertiesFile(String prefix) {
        File propsFile = FILE_UTILS.createTempFile(prefix, ".properties", this.tmpDir != null ? this.tmpDir : this.getProject().getBaseDir(), true, true);
        return propsFile;
    }

    protected void handleOutput(String output) {
        if (output.startsWith(TESTLISTENER_PREFIX)) {
            this.log(output, 3);
        } else if (this.runner != null) {
            if (this.outputToFormatters) {
                this.runner.handleOutput(output);
            }
            if (this.showOutput) {
                super.handleOutput(output);
            }
        } else {
            super.handleOutput(output);
        }
    }

    protected int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.runner != null) {
            return this.runner.handleInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    protected void handleFlush(String output) {
        if (this.runner != null) {
            this.runner.handleFlush(output);
            if (this.showOutput) {
                super.handleFlush(output);
            }
        } else {
            super.handleFlush(output);
        }
    }

    public void handleErrorOutput(String output) {
        if (this.runner != null) {
            this.runner.handleErrorOutput(output);
            if (this.showOutput) {
                super.handleErrorOutput(output);
            }
        } else {
            super.handleErrorOutput(output);
        }
    }

    public void handleErrorFlush(String output) {
        if (this.runner != null) {
            this.runner.handleErrorFlush(output);
            if (this.showOutput) {
                super.handleErrorFlush(output);
            }
        } else {
            super.handleErrorFlush(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestResultHolder executeInVM(JUnitTest arg) throws BuildException {
        TestResultHolder testResultHolder;
        block16: {
            CommandlineJava.SysProperties sysProperties;
            if (this.delegate == null) {
                this.setupJUnitDelegate();
            }
            JUnitTest test = (JUnitTest)arg.clone();
            test.setProperties(this.getProject().getProperties());
            if (this.dir != null) {
                this.log("dir attribute ignored if running in the same VM", 1);
            }
            if (this.newEnvironment || null != this.env.getVariables()) {
                this.log("Changes to environment variables are ignored if running in the same VM.", 1);
            }
            if (this.getCommandline().getBootclasspath() != null) {
                this.log("bootclasspath is ignored if running in the same VM.", 1);
            }
            if ((sysProperties = this.getCommandline().getSystemProperties()) != null) {
                sysProperties.setSystem();
            }
            try {
                this.log("Using System properties " + System.getProperties(), 3);
                if (this.splitJunit) {
                    this.classLoader = (AntClassLoader)this.delegate.getClass().getClassLoader();
                } else {
                    this.createClassLoader();
                }
                if (this.classLoader != null) {
                    this.classLoader.setThreadContextLoader();
                }
                this.runner = this.delegate.newJUnitTestRunner(test, test.getMethods(), test.getHaltonerror(), test.getFiltertrace(), test.getHaltonfailure(), false, this.getEnableTestListenerEvents(), this.classLoader);
                if (this.summary) {
                    JUnitTaskMirror.SummaryJUnitResultFormatterMirror f = this.delegate.newSummaryJUnitResultFormatter();
                    f.setWithOutAndErr(this.equalsWithOutAndErr(this.summaryValue));
                    f.setOutput(this.getDefaultOutput());
                    this.runner.addFormatter(f);
                }
                this.runner.setPermissions(this.perm);
                FormatterElement[] feArray = this.mergeFormatters(test);
                for (int i = 0; i < feArray.length; ++i) {
                    FormatterElement fe = feArray[i];
                    if (!fe.shouldUse(this)) continue;
                    File outFile = this.getOutput(fe, test);
                    if (outFile != null) {
                        fe.setOutfile(outFile);
                    } else {
                        fe.setOutput(this.getDefaultOutput());
                    }
                    this.runner.addFormatter(fe.createFormatter((ClassLoader)this.classLoader));
                }
                this.runner.run();
                TestResultHolder result = new TestResultHolder();
                result.exitCode = this.runner.getRetCode();
                testResultHolder = result;
                Object var9_9 = null;
                if (sysProperties == null) break block16;
            }
            catch (Throwable throwable) {
                block17: {
                    Object var9_10 = null;
                    if (sysProperties != null) {
                        sysProperties.restoreSystem();
                    }
                    if (this.classLoader == null) break block17;
                    this.classLoader.resetThreadContextLoader();
                }
                throw throwable;
            }
            sysProperties.restoreSystem();
        }
        if (this.classLoader != null) {
            this.classLoader.resetThreadContextLoader();
        }
        return testResultHolder;
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog((long)this.timeout.intValue());
    }

    protected OutputStream getDefaultOutput() {
        return new LogOutputStream((Task)this, 2);
    }

    protected Enumeration getIndividualTests() {
        int count = this.batchTests.size();
        Enumeration[] enums = new Enumeration[count + 1];
        for (int i = 0; i < count; ++i) {
            BatchTest batchtest = (BatchTest)this.batchTests.elementAt(i);
            enums[i] = batchtest.elements();
        }
        enums[enums.length - 1] = this.tests.elements();
        return Enumerations.fromCompound(enums);
    }

    private void checkMethodLists() throws BuildException {
        if (this.tests.isEmpty()) {
            return;
        }
        Enumeration testsEnum = this.tests.elements();
        while (testsEnum.hasMoreElements()) {
            JUnitTest test = (JUnitTest)testsEnum.nextElement();
            if (!test.hasMethodsSpecified() || !test.shouldRun(this.getProject())) continue;
            test.resolveMethods();
        }
    }

    protected Enumeration allTests() {
        Enumeration[] enums = new Enumeration[]{this.tests.elements(), this.batchTests.elements()};
        return Enumerations.fromCompound(enums);
    }

    private FormatterElement[] mergeFormatters(JUnitTest test) {
        Vector feVector = (Vector)this.formatters.clone();
        test.addFormattersTo(feVector);
        Object[] feArray = new FormatterElement[feVector.size()];
        feVector.copyInto(feArray);
        return feArray;
    }

    protected File getOutput(FormatterElement fe, JUnitTest test) {
        if (fe.getUseFile()) {
            String base = test.getOutfile();
            if (base == null) {
                base = "IGNORETHIS";
            }
            String filename = base + fe.getExtension();
            File destFile = new File(test.getTodir(), filename);
            String absFilename = destFile.getAbsolutePath();
            return this.getProject().resolveFile(absFilename);
        }
        return null;
    }

    protected void addClasspathEntry(String resource) {
        this.addClasspathResource(resource);
    }

    private boolean addClasspathResource(String resource) {
        resource = resource.startsWith("/") ? resource.substring(1) : "org/apache/tools/ant/taskdefs/optional/junit/" + resource;
        File f = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)resource);
        if (f != null) {
            this.log("Found " + f.getAbsolutePath(), 4);
            this.antRuntimeClasses.createPath().setLocation(f);
            return true;
        }
        this.log("Couldn't find " + resource, 4);
        return false;
    }

    private void logTimeout(FormatterElement[] feArray, JUnitTest test, String testCase) {
        this.logVmExit(feArray, test, TIMEOUT_MESSAGE, testCase);
    }

    private void logVmCrash(FormatterElement[] feArray, JUnitTest test, String testCase) {
        this.logVmExit(feArray, test, "Forked Java VM exited abnormally. Please note the time in the report does not reflect the time until the VM exit.", testCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logVmExit(FormatterElement[] feArray, JUnitTest test, String message, String testCase) {
        if (this.delegate == null) {
            this.setupJUnitDelegate();
        }
        try {
            this.log("Using System properties " + System.getProperties(), 3);
            if (this.splitJunit) {
                this.classLoader = (AntClassLoader)this.delegate.getClass().getClassLoader();
            } else {
                this.createClassLoader();
            }
            if (this.classLoader != null) {
                this.classLoader.setThreadContextLoader();
            }
            test.setCounts(1L, 0L, 1L);
            test.setProperties(this.getProject().getProperties());
            for (int i = 0; i < feArray.length; ++i) {
                JUnitTaskMirror.JUnitResultFormatterMirror formatter;
                FormatterElement fe = feArray[i];
                if (!fe.shouldUse(this) || (formatter = fe.createFormatter((ClassLoader)this.classLoader)) == null) continue;
                OutputStream out = null;
                File outFile = this.getOutput(fe, test);
                if (outFile != null) {
                    try {
                        out = new FileOutputStream(outFile);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (out == null) {
                    out = this.getDefaultOutput();
                }
                this.delegate.addVmExit(test, formatter, out, message, testCase);
            }
            if (this.summary) {
                JUnitTaskMirror.SummaryJUnitResultFormatterMirror f = this.delegate.newSummaryJUnitResultFormatter();
                f.setWithOutAndErr(this.equalsWithOutAndErr(this.summaryValue));
                this.delegate.addVmExit(test, f, this.getDefaultOutput(), message, testCase);
            }
            Object var12_12 = null;
            if (this.classLoader == null) return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (this.classLoader == null) throw throwable;
            this.classLoader.resetThreadContextLoader();
            throw throwable;
        }
        this.classLoader.resetThreadContextLoader();
    }

    private void createClassLoader() {
        Path userClasspath = this.getCommandline().getClasspath();
        if (userClasspath != null && (this.reloading || this.classLoader == null)) {
            this.deleteClassLoader();
            Path classpath = (Path)userClasspath.clone();
            if (this.includeAntRuntime) {
                this.log("Implicitly adding " + this.antRuntimeClasses + " to CLASSPATH", 3);
                classpath.append(this.antRuntimeClasses);
            }
            this.classLoader = this.getProject().createClassLoader(classpath);
            if (((Object)((Object)this)).getClass().getClassLoader() != null && ((Object)((Object)this)).getClass().getClassLoader() != Project.class.getClassLoader()) {
                this.classLoader.setParent(((Object)((Object)this)).getClass().getClassLoader());
            }
            this.classLoader.setParentFirst(false);
            this.classLoader.addJavaLibraries();
            this.log("Using CLASSPATH " + this.classLoader.getClasspath(), 3);
            this.classLoader.addSystemPackageRoot("junit");
            this.classLoader.addSystemPackageRoot("org.junit");
            this.classLoader.addSystemPackageRoot("org.apache.tools.ant");
        }
    }

    protected void cleanup() {
        this.deleteClassLoader();
        this.delegate = null;
    }

    private void deleteClassLoader() {
        if (this.classLoader != null) {
            this.classLoader.cleanup();
            this.classLoader = null;
        }
        if (this.mirrorLoader instanceof SplitClassLoader) {
            ((SplitClassLoader)this.mirrorLoader).cleanup();
        }
        this.mirrorLoader = null;
    }

    protected CommandlineJava getCommandline() {
        if (this.commandline == null) {
            this.commandline = new CommandlineJava();
            this.commandline.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
        }
        return this.commandline;
    }

    protected Collection executeOrQueue(Enumeration testList, boolean runIndividual) {
        HashMap<ForkedTestConfiguration, ArrayList<JUnitTest>> testConfigurations = new HashMap<ForkedTestConfiguration, ArrayList<JUnitTest>>();
        while (testList.hasMoreElements()) {
            JUnitTest test = (JUnitTest)testList.nextElement();
            if (!test.shouldRun(this.getProject())) continue;
            if (runIndividual || !test.getFork()) {
                this.execute(test);
                continue;
            }
            ForkedTestConfiguration c = new ForkedTestConfiguration(test);
            ArrayList<JUnitTest> l = (ArrayList<JUnitTest>)testConfigurations.get(c);
            if (l == null) {
                l = new ArrayList<JUnitTest>();
                testConfigurations.put(c, l);
            }
            l.add(test);
        }
        return testConfigurations.values();
    }

    protected void actOnTestResult(int exitValue, boolean wasKilled, JUnitTest test, String name) {
        TestResultHolder t = new TestResultHolder();
        t.exitCode = exitValue;
        t.timedOut = wasKilled;
        this.actOnTestResult(t, test, name);
    }

    protected void actOnTestResult(TestResultHolder result, JUnitTest test, String name) {
        boolean failureOccurredHere;
        boolean fatal = result.timedOut || result.crashed;
        boolean errorOccurredHere = result.exitCode == 2 || fatal;
        boolean bl = failureOccurredHere = result.exitCode != 0 || fatal;
        if (errorOccurredHere || failureOccurredHere) {
            if (errorOccurredHere && test.getHaltonerror() || failureOccurredHere && test.getHaltonfailure()) {
                throw new BuildException(name + " failed" + (result.timedOut ? " (timeout)" : "") + (result.crashed ? " (crashed)" : ""), this.getLocation());
            }
            if (this.logFailedTests) {
                this.log(name + " FAILED" + (result.timedOut ? " (timeout)" : "") + (result.crashed ? " (crashed)" : ""), 0);
            }
            if (errorOccurredHere && test.getErrorProperty() != null) {
                this.getProject().setNewProperty(test.getErrorProperty(), "true");
            }
            if (failureOccurredHere && test.getFailureProperty() != null) {
                this.getProject().setNewProperty(test.getFailureProperty(), "true");
            }
        }
    }

    private static JUnitTest createDummyTestForBatchTest(JUnitTest test) {
        JUnitTest t = (JUnitTest)test.clone();
        int index = test.getName().lastIndexOf(46);
        String pack = index > 0 ? test.getName().substring(0, index + 1) : "";
        t.setName(pack + NAME_OF_DUMMY_TEST);
        return t;
    }

    private static void printDual(BufferedWriter w, PrintStream s, String text) throws IOException {
        w.write(String.valueOf(text));
        s.print(text);
    }

    private static void printlnDual(BufferedWriter w, PrintStream s, String text) throws IOException {
        w.write(String.valueOf(text));
        w.newLine();
        s.println(text);
    }

    protected static class JUnitLogStreamHandler
    extends PumpStreamHandler {
        public JUnitLogStreamHandler(Task task, int outlevel, int errlevel) {
            super((OutputStream)((Object)new JUnitLogOutputStream(task, outlevel)), (OutputStream)new LogOutputStream(task, errlevel));
        }
    }

    protected static class JUnitLogOutputStream
    extends LogOutputStream {
        private Task task;

        public JUnitLogOutputStream(Task task, int level) {
            super(task, level);
            this.task = task;
        }

        protected void processLine(String line, int level) {
            if (line.startsWith(JUnitTask.TESTLISTENER_PREFIX)) {
                this.task.log(line, 3);
            } else {
                super.processLine(line, level);
            }
        }
    }

    protected static class TestResultHolder {
        public int exitCode = 2;
        public boolean timedOut = false;
        public boolean crashed = false;

        protected TestResultHolder() {
        }
    }

    public static final class ForkMode
    extends EnumeratedAttribute {
        public static final String ONCE = "once";
        public static final String PER_TEST = "perTest";
        public static final String PER_BATCH = "perBatch";

        public ForkMode() {
        }

        public ForkMode(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return new String[]{ONCE, PER_TEST, PER_BATCH};
        }
    }

    private static final class ForkedTestConfiguration {
        private boolean filterTrace;
        private boolean haltOnError;
        private boolean haltOnFailure;
        private String errorProperty;
        private String failureProperty;

        ForkedTestConfiguration(boolean filterTrace, boolean haltOnError, boolean haltOnFailure, String errorProperty, String failureProperty) {
            this.filterTrace = filterTrace;
            this.haltOnError = haltOnError;
            this.haltOnFailure = haltOnFailure;
            this.errorProperty = errorProperty;
            this.failureProperty = failureProperty;
        }

        ForkedTestConfiguration(JUnitTest test) {
            this(test.getFiltertrace(), test.getHaltonerror(), test.getHaltonfailure(), test.getErrorProperty(), test.getFailureProperty());
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != (class$org$apache$tools$ant$taskdefs$optional$junit$JUnitTask$ForkedTestConfiguration == null ? (class$org$apache$tools$ant$taskdefs$optional$junit$JUnitTask$ForkedTestConfiguration = JUnitTask.class$("org.apache.tools.ant.taskdefs.optional.junit.JUnitTask$ForkedTestConfiguration")) : class$org$apache$tools$ant$taskdefs$optional$junit$JUnitTask$ForkedTestConfiguration)) {
                return false;
            }
            ForkedTestConfiguration o = (ForkedTestConfiguration)other;
            return this.filterTrace == o.filterTrace && this.haltOnError == o.haltOnError && this.haltOnFailure == o.haltOnFailure && (this.errorProperty == null && o.errorProperty == null || this.errorProperty != null && this.errorProperty.equals(o.errorProperty)) && (this.failureProperty == null && o.failureProperty == null || this.failureProperty != null && this.failureProperty.equals(o.failureProperty));
        }

        public int hashCode() {
            return (this.filterTrace ? 1 : 0) + (this.haltOnError ? 2 : 0) + (this.haltOnFailure ? 4 : 0);
        }
    }

    public static class SummaryAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"true", "yes", "false", "no", "on", "off", "withOutAndErr"};
        }

        public boolean asBoolean() {
            String v = this.getValue();
            return "true".equals(v) || "on".equals(v) || "yes".equals(v) || "withOutAndErr".equals(v);
        }
    }
}

