/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.commons.httpclient.util;

import hidden.org.apache.commons.httpclient.HttpConnectionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IdleConnectionTimeoutThread
extends Thread {
    private List connectionManagers = new ArrayList();
    private boolean shutdown = false;
    private long timeoutInterval = 1000L;
    private long connectionTimeout = 3000L;

    public IdleConnectionTimeoutThread() {
        this.setDaemon(true);
    }

    public synchronized void addConnectionManager(HttpConnectionManager connectionManager) {
        if (this.shutdown) {
            throw new IllegalStateException("IdleConnectionTimeoutThread has been shutdown");
        }
        this.connectionManagers.add(connectionManager);
    }

    public synchronized void removeConnectionManager(HttpConnectionManager connectionManager) {
        if (this.shutdown) {
            throw new IllegalStateException("IdleConnectionTimeoutThread has been shutdown");
        }
        this.connectionManagers.remove(connectionManager);
    }

    protected void handleCloseIdleConnections(HttpConnectionManager connectionManager) {
        connectionManager.closeIdleConnections(this.connectionTimeout);
    }

    public synchronized void run() {
        while (!this.shutdown) {
            Iterator iter = this.connectionManagers.iterator();
            while (iter.hasNext()) {
                HttpConnectionManager connectionManager = (HttpConnectionManager)iter.next();
                this.handleCloseIdleConnections(connectionManager);
            }
            try {
                this.wait(this.timeoutInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.connectionManagers.clear();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.notifyAll();
    }

    public synchronized void setConnectionTimeout(long connectionTimeout) {
        if (this.shutdown) {
            throw new IllegalStateException("IdleConnectionTimeoutThread has been shutdown");
        }
        this.connectionTimeout = connectionTimeout;
    }

    public synchronized void setTimeoutInterval(long timeoutInterval) {
        if (this.shutdown) {
            throw new IllegalStateException("IdleConnectionTimeoutThread has been shutdown");
        }
        this.timeoutInterval = timeoutInterval;
    }
}

