/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import hidden.org.codehaus.plexus.util.FileUtils;
import hidden.org.codehaus.plexus.util.Os;
import hidden.org.codehaus.plexus.util.StringUtils;
import hidden.org.codehaus.plexus.util.dag.CycleDetectedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.maven.BuildFailureException;
import org.apache.maven.Maven;
import org.apache.maven.SettingsConfigurationException;
import org.apache.maven.artifact.manager.DefaultWagonManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DefaultArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.model.Profile;
import org.apache.maven.monitor.event.DefaultEventDispatcher;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MissingProjectException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reactor.MavenExecutionException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.usability.SystemWarnings;
import org.apache.maven.usability.diagnostics.ErrorDiagnostics;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class DefaultMaven
extends AbstractLogEnabled
implements Maven,
Contextualizable {
    protected MavenProjectBuilder projectBuilder;
    protected LifecycleExecutor lifecycleExecutor;
    protected PlexusContainer container;
    protected ErrorDiagnostics errorDiagnostics;
    protected RuntimeInformation runtimeInformation;
    private static final long MB = 0x100000L;
    private static final int MS_PER_SEC = 1000;
    private static final int SEC_PER_MIN = 60;

    public void execute(MavenExecutionRequest request) throws MavenExecutionException {
        ReactorManager rm;
        EventDispatcher dispatcher = request.getEventDispatcher();
        String event = "reactor-execute";
        dispatcher.dispatchStart(event, request.getBaseDirectory());
        try {
            rm = this.doExecute(request, dispatcher);
        }
        catch (LifecycleExecutionException e) {
            dispatcher.dispatchError(event, request.getBaseDirectory(), e);
            this.logError(e, request.isShowErrors());
            this.stats(request.getStartTime());
            this.line();
            throw new MavenExecutionException(e.getMessage(), e);
        }
        catch (BuildFailureException e) {
            dispatcher.dispatchError(event, request.getBaseDirectory(), e);
            this.logFailure(e, request.isShowErrors());
            this.stats(request.getStartTime());
            this.line();
            throw new MavenExecutionException(e.getMessage(), e);
        }
        catch (Throwable t) {
            dispatcher.dispatchError(event, request.getBaseDirectory(), t);
            this.logFatal(t);
            this.stats(request.getStartTime());
            this.line();
            throw new MavenExecutionException("Error executing project within the reactor", t);
        }
        this.logReactorSummary(rm);
        if (rm.hasBuildFailures()) {
            this.logErrors(rm, request.isShowErrors());
            if (!"fail-never".equals(rm.getFailureBehavior())) {
                dispatcher.dispatchError(event, request.getBaseDirectory(), null);
                this.getLogger().info("BUILD ERRORS");
                this.line();
                this.stats(request.getStartTime());
                this.line();
                throw new MavenExecutionException("Some builds failed");
            }
            this.getLogger().info(" + Ignoring failures");
        }
        this.logSuccess(rm);
        this.stats(request.getStartTime());
        this.line();
        dispatcher.dispatchEnd(event, request.getBaseDirectory());
    }

    private void logErrors(ReactorManager rm, boolean showErrors) {
        for (MavenProject project : rm.getSortedProjects()) {
            if (!rm.hasBuildFailure(project)) continue;
            BuildFailure buildFailure = rm.getBuildFailure(project);
            this.getLogger().info("Error for project: " + project.getName() + " (during " + buildFailure.getTask() + ")");
            this.line();
            this.logDiagnostics(buildFailure.getCause());
            this.logTrace(buildFailure.getCause(), showErrors);
        }
        if (!showErrors) {
            this.getLogger().info("For more information, run Maven with the -e switch");
            this.line();
        }
    }

    private ReactorManager doExecute(MavenExecutionRequest request, EventDispatcher dispatcher) throws MavenExecutionException, BuildFailureException, LifecycleExecutionException {
        ReactorManager rm;
        if (request.getSettings().isOffline()) {
            this.getLogger().info(SystemWarnings.getOfflineWarning());
            WagonManager wagonManager = null;
            try {
                wagonManager = (WagonManager)this.container.lookup(WagonManager.ROLE);
                wagonManager.setOnline(false);
            }
            catch (ComponentLookupException e) {
                throw new MavenExecutionException("Cannot retrieve WagonManager in order to set offline mode.", e);
            }
            finally {
                try {
                    this.container.release(wagonManager);
                }
                catch (ComponentLifecycleException e) {
                    this.getLogger().warn("Cannot release WagonManager.", e);
                }
            }
        }
        try {
            this.resolveParameters(request.getSettings(), request.getExecutionProperties());
        }
        catch (ComponentLookupException e) {
            throw new MavenExecutionException("Unable to configure Maven for execution", e);
        }
        catch (ComponentLifecycleException e) {
            throw new MavenExecutionException("Unable to configure Maven for execution", e);
        }
        catch (SettingsConfigurationException e) {
            throw new MavenExecutionException("Unable to configure Maven for execution", e);
        }
        ProfileManager globalProfileManager = request.getGlobalProfileManager();
        globalProfileManager.loadSettingsProfiles(request.getSettings());
        this.getLogger().info("Scanning for projects...");
        boolean foundProjects = true;
        List projects = this.getProjects(request);
        if (projects.isEmpty()) {
            projects.add(this.getSuperProject(request));
            foundProjects = false;
        }
        try {
            String resumeFrom = request.getResumeFrom();
            List projectList = request.getSelectedProjects();
            String makeBehavior = request.getMakeBehavior();
            rm = new ReactorManager(projects, projectList, resumeFrom, makeBehavior);
            rm.setFailureBehavior(request.getFailureBehavior());
        }
        catch (CycleDetectedException e) {
            throw new BuildFailureException("The projects in the reactor contain a cyclic reference: " + e.getMessage(), e);
        }
        catch (DuplicateProjectException e) {
            throw new BuildFailureException(e.getMessage(), e);
        }
        catch (MissingProjectException e) {
            throw new BuildFailureException(e.getMessage(), e);
        }
        this.validateActivatedProfiles(globalProfileManager, projects);
        if (rm.hasMultipleProjects()) {
            this.getLogger().info("Reactor build order: ");
            for (MavenProject project : rm.getSortedProjects()) {
                this.getLogger().info("  " + project.getName());
            }
        }
        MavenSession session = this.createSession(request, rm);
        session.setUsingPOMsFromFilesystem(foundProjects);
        this.lifecycleExecutor.execute(session, rm, dispatcher);
        return rm;
    }

    private void validateActivatedProfiles(ProfileManager globalProfileManager, List projects) {
        if (globalProfileManager != null) {
            HashSet<String> activeProfileIds = new HashSet<String>();
            for (MavenProject project : projects) {
                do {
                    Iterator j = project.getActiveProfiles().iterator();
                    while (j.hasNext()) {
                        activeProfileIds.add(((Profile)j.next()).getId());
                    }
                } while ((project = project.getParent()) != null);
            }
            for (String explicitProfileId : globalProfileManager.getExplicitlyActivatedIds()) {
                if (activeProfileIds.contains(explicitProfileId)) continue;
                this.getLogger().warn("\n\tProfile with id: '" + explicitProfileId + "' has not been activated.\n");
            }
        }
    }

    private MavenProject getSuperProject(MavenExecutionRequest request) throws MavenExecutionException {
        MavenProject superProject;
        try {
            superProject = this.projectBuilder.buildStandaloneSuperProject(request.getLocalRepository(), request.getGlobalProfileManager());
        }
        catch (ProjectBuildingException e) {
            throw new MavenExecutionException(e.getMessage(), e);
        }
        return superProject;
    }

    private List getProjects(MavenExecutionRequest request) throws MavenExecutionException, BuildFailureException {
        List projects;
        try {
            List files = this.getProjectFiles(request);
            projects = this.collectProjects(files, request, !request.isReactorActive());
        }
        catch (IOException e) {
            throw new MavenExecutionException("Error processing projects for the reactor: " + e.getMessage(), e);
        }
        catch (ArtifactResolutionException e) {
            throw new MavenExecutionException(e.getMessage(), e);
        }
        catch (ProjectBuildingException e) {
            throw new MavenExecutionException(e.getMessage(), e);
        }
        catch (ProfileActivationException e) {
            throw new MavenExecutionException(e.getMessage(), e);
        }
        return projects;
    }

    private void logReactorSummaryLine(String name, String status) {
        this.logReactorSummaryLine(name, status, -1L);
    }

    private void logReactorSummaryLine(String name, String status, long time) {
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append(name);
        int dotCount = 54;
        dotCount -= name.length();
        messageBuffer.append(" ");
        for (int i = 0; i < dotCount; ++i) {
            messageBuffer.append('.');
        }
        messageBuffer.append(" ");
        messageBuffer.append(status);
        if (time >= 0L) {
            messageBuffer.append(" [");
            messageBuffer.append(DefaultMaven.getFormattedTime(time));
            messageBuffer.append("]");
        }
        this.getLogger().info(messageBuffer.toString());
    }

    private static String getFormattedTime(long time) {
        String pattern = "s.SSS's'";
        if (time / 60000L > 0L) {
            pattern = "m:s" + pattern;
            if (time / 3600000L > 0L) {
                pattern = "H:m" + pattern;
            }
        }
        SimpleDateFormat fmt = new SimpleDateFormat(pattern);
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt.format(new Date(time));
    }

    private List collectProjects(List files, MavenExecutionRequest request, boolean isRoot) throws ArtifactResolutionException, ProjectBuildingException, ProfileActivationException, MavenExecutionException, BuildFailureException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>(files.size());
        for (File file : files) {
            boolean usingReleasePom = false;
            if ("release-pom.xml".equals(file.getName())) {
                this.getLogger().info("NOTE: Using release-pom: " + file + " in reactor build.");
                usingReleasePom = true;
            }
            MavenProject project = this.getProject(file, request);
            if (isRoot) {
                project.setExecutionRoot(true);
            }
            if (project.getPrerequisites() != null && project.getPrerequisites().getMaven() != null) {
                DefaultArtifactVersion version = new DefaultArtifactVersion(project.getPrerequisites().getMaven());
                if (this.runtimeInformation.getApplicationVersion().compareTo(version) < 0) {
                    throw new BuildFailureException("Unable to build project '" + project.getFile() + "; it requires Maven version " + version.toString());
                }
            }
            if (project.getModules() != null && !project.getModules().isEmpty() && request.isRecursive()) {
                project.setPackaging("pom");
                File basedir = file.getParentFile();
                ArrayList<File> moduleFiles = new ArrayList<File>(project.getModules().size());
                for (String name : project.getModules()) {
                    if (StringUtils.isEmpty(StringUtils.trim(name))) {
                        this.getLogger().warn("Empty module detected. Please check you don't have any empty module definitions in your POM.");
                        continue;
                    }
                    File moduleFile = new File(basedir, name);
                    if (moduleFile.exists() && moduleFile.isDirectory()) {
                        moduleFile = usingReleasePom ? new File(basedir, name + "/" + "release-pom.xml") : new File(basedir, name + "/" + "pom.xml");
                    }
                    if (Os.isFamily("windows")) {
                        try {
                            moduleFile = moduleFile.getCanonicalFile();
                        }
                        catch (IOException e) {
                            throw new MavenExecutionException("Unable to canonicalize file name " + moduleFile, e);
                        }
                    } else {
                        moduleFile = new File(moduleFile.toURI().normalize());
                    }
                    moduleFiles.add(moduleFile);
                }
                List collectedProjects = this.collectProjects(moduleFiles, request, false);
                projects.addAll(collectedProjects);
                project.setCollectedProjects(collectedProjects);
            }
            projects.add(project);
        }
        return projects;
    }

    public MavenProject getProject(File pom, ArtifactRepository localRepository, Settings settings, Properties userProperties, ProfileManager globalProfileManager) throws ProjectBuildingException, ArtifactResolutionException, ProfileActivationException {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest(localRepository, settings, new DefaultEventDispatcher(), Collections.EMPTY_LIST, pom.getParentFile().getAbsolutePath(), globalProfileManager, globalProfileManager.getRequestProperties(), new Properties(), false);
        return this.getProject(pom, request);
    }

    public MavenProject getProject(File pom, MavenExecutionRequest request) throws ProjectBuildingException, ArtifactResolutionException, ProfileActivationException {
        if (pom.exists() && pom.length() == 0L) {
            throw new ProjectBuildingException("unknown", "The file " + pom.getAbsolutePath() + " you specified has zero length.");
        }
        return this.projectBuilder.build(pom, request.getProjectBuilderConfiguration());
    }

    protected MavenSession createSession(MavenExecutionRequest request, ReactorManager rpm) {
        return new MavenSession(this.container, request.getSettings(), request.getLocalRepository(), request.getEventDispatcher(), rpm, request.getGoals(), request.getBaseDirectory(), request.getExecutionProperties(), request.getUserProperties(), request.getStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveParameters(Settings settings, Properties executionProperties) throws ComponentLookupException, ComponentLifecycleException, SettingsConfigurationException {
        WagonManager wagonManager;
        try {
            wagonManager = (DefaultWagonManager)this.container.lookup(WagonManager.ROLE);
            String oldUserAgent = ((DefaultWagonManager)wagonManager).getHttpUserAgent();
            int firstSpace = oldUserAgent == null ? -1 : oldUserAgent.indexOf(" ");
            StringBuffer buffer = new StringBuffer();
            buffer.append("Apache-Maven/");
            ArtifactVersion version = this.runtimeInformation.getApplicationVersion();
            if (version != null) {
                buffer.append(version.getMajorVersion());
                buffer.append('.');
                buffer.append(version.getMinorVersion());
            } else {
                buffer.append("unknown");
            }
            buffer.append(' ');
            if (firstSpace > -1) {
                buffer.append(oldUserAgent.substring(firstSpace + 1));
                buffer.append(' ');
                buffer.append(oldUserAgent.substring(0, firstSpace));
            } else {
                buffer.append(oldUserAgent);
            }
            ((DefaultWagonManager)wagonManager).setHttpUserAgent(buffer.toString());
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        wagonManager = (WagonManager)this.container.lookup(WagonManager.ROLE);
        SecDispatcher sd = null;
        try {
            Proxy proxy = settings.getActiveProxy();
            try {
                sd = (SecDispatcher)this.container.lookup(SecDispatcher.ROLE, "maven");
            }
            catch (Exception e) {
                this.getLogger().warn("Security features are disabled. Cannot find plexus component " + SecDispatcher.ROLE + ":maven");
                this.line();
            }
            if (proxy != null) {
                if (proxy.getHost() == null) {
                    throw new SettingsConfigurationException("Proxy in settings.xml has no host");
                }
                String pass = proxy.getPassword();
                if (sd != null) {
                    try {
                        pass = sd.decrypt(pass);
                    }
                    catch (SecDispatcherException e) {
                        this.reportSecurityConfigurationError("password for proxy '" + proxy.getId() + "'", e);
                    }
                }
                wagonManager.addProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), pass, proxy.getNonProxyHosts());
            }
            for (Server server : settings.getServers()) {
                String passWord = server.getPassword();
                if (sd != null) {
                    try {
                        passWord = sd.decrypt(passWord);
                    }
                    catch (SecDispatcherException e) {
                        this.reportSecurityConfigurationError("password for server '" + server.getId() + "'", e);
                    }
                }
                String passPhrase = server.getPassphrase();
                if (sd != null) {
                    try {
                        passPhrase = sd.decrypt(passPhrase);
                    }
                    catch (SecDispatcherException e) {
                        this.reportSecurityConfigurationError("passphrase for server '" + server.getId() + "'", e);
                    }
                }
                wagonManager.addAuthenticationInfo(server.getId(), server.getUsername(), passWord, server.getPrivateKey(), passPhrase);
                wagonManager.addPermissionInfo(server.getId(), server.getFilePermissions(), server.getDirectoryPermissions());
                if (server.getConfiguration() == null) continue;
                wagonManager.addConfiguration(server.getId(), (Xpp3Dom)server.getConfiguration());
            }
            for (Mirror mirror : settings.getMirrors()) {
                wagonManager.addMirror(mirror.getId(), mirror.getMirrorOf(), mirror.getUrl());
            }
        }
        finally {
            this.container.release(wagonManager);
            if (sd != null) {
                this.container.release(sd);
            }
        }
        String numThreads = System.getProperty("maven.artifact.threads");
        if (numThreads != null) {
            int threads = 0;
            try {
                threads = Integer.valueOf(numThreads);
                if (threads < 1) {
                    this.getLogger().warn("Invalid number of threads '" + threads + "' will be ignored");
                }
            }
            catch (NumberFormatException e) {
                this.getLogger().warn("Invalid number of threads '" + numThreads + "' will be ignored: " + e.getMessage());
            }
            if (threads > 0) {
                DefaultArtifactResolver artifactResolver = (DefaultArtifactResolver)this.container.lookup(ArtifactResolver.ROLE);
                try {
                    artifactResolver.configureNumberOfThreads(threads);
                    this.getLogger().debug("Resolution thread pool size set to: " + threads);
                }
                finally {
                    this.container.release(artifactResolver);
                }
            }
        }
    }

    private void reportSecurityConfigurationError(String affectedConfiguration, SecDispatcherException e) {
        Throwable cause = e;
        String msg = "Not decrypting " + affectedConfiguration + " due to exception in security handler.";
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof FileNotFoundException) {
            msg = msg + "\nEnsure that you have configured your master password file (and relocation if appropriate)\nSee the installation instructions for details.";
        }
        this.getLogger().warn(msg + "\nCause: " + cause.getMessage());
        this.getLogger().debug("Full trace follows", e);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    protected void logFatal(Throwable error) {
        this.line();
        this.getLogger().error("FATAL ERROR");
        this.line();
        this.logDiagnostics(error);
        this.logTrace(error, true);
    }

    protected void logError(Exception e, boolean showErrors) {
        this.line();
        this.getLogger().error("BUILD ERROR");
        this.line();
        this.logDiagnostics(e);
        this.logTrace(e, showErrors);
        if (!showErrors) {
            this.getLogger().info("For more information, run Maven with the -e switch");
            this.line();
        }
    }

    protected void logFailure(BuildFailureException e, boolean showErrors) {
        this.line();
        this.getLogger().error("BUILD FAILURE");
        this.line();
        this.logDiagnostics(e);
        this.logTrace(e, showErrors);
        if (!showErrors) {
            this.getLogger().info("For more information, run Maven with the -e switch");
            this.line();
        }
    }

    private void logTrace(Throwable t, boolean showErrors) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trace", t);
            this.line();
        } else if (showErrors) {
            this.getLogger().info("Trace", t);
            this.line();
        }
    }

    private void logDiagnostics(Throwable t) {
        String message = null;
        if (this.errorDiagnostics != null) {
            message = this.errorDiagnostics.diagnose(t);
        }
        if (message == null) {
            message = t.getMessage();
        }
        this.getLogger().info(message);
        this.line();
    }

    protected void logSuccess(ReactorManager rm) {
        this.line();
        this.getLogger().info("BUILD SUCCESSFUL");
        this.line();
    }

    private void logReactorSummary(ReactorManager rm) {
        if (rm.hasMultipleProjects() && rm.executedMultipleProjects()) {
            this.getLogger().info("");
            this.getLogger().info("");
            this.line();
            this.getLogger().info("Reactor Summary:");
            this.line();
            for (MavenProject project : rm.getSortedProjects()) {
                if (rm.hasBuildFailure(project)) {
                    this.logReactorSummaryLine(project.getName(), "FAILED", rm.getBuildFailure(project).getTime());
                    continue;
                }
                if (rm.isBlackListed(project)) {
                    this.logReactorSummaryLine(project.getName(), "SKIPPED (dependency build failed or was skipped)");
                    continue;
                }
                if (rm.hasBuildSuccess(project)) {
                    this.logReactorSummaryLine(project.getName(), "SUCCESS", rm.getBuildSuccess(project).getTime());
                    continue;
                }
                this.logReactorSummaryLine(project.getName(), "NOT BUILT");
            }
            this.line();
        }
    }

    protected void stats(Date start) {
        Date finish = new Date();
        long time = finish.getTime() - start.getTime();
        this.getLogger().info("Total time: " + DefaultMaven.formatTime(time));
        this.getLogger().info("Finished at: " + finish);
        System.gc();
        Runtime r = Runtime.getRuntime();
        this.getLogger().info("Final Memory: " + (r.totalMemory() - r.freeMemory()) / 0x100000L + "M/" + r.totalMemory() / 0x100000L + "M");
    }

    protected void line() {
        this.getLogger().info("------------------------------------------------------------------------");
    }

    protected static String formatTime(long ms) {
        long secs = ms / 1000L;
        long min = secs / 60L;
        secs %= 60L;
        String msg = "";
        if (min > 1L) {
            msg = min + " minutes ";
        } else if (min == 1L) {
            msg = "1 minute ";
        }
        if (secs > 1L) {
            msg = msg + secs + " seconds";
        } else if (secs == 1L) {
            msg = msg + "1 second";
        } else if (min == 0L) {
            msg = msg + "< 1 second";
        }
        return msg;
    }

    private List getProjectFiles(MavenExecutionRequest request) throws IOException {
        List<File> files = Collections.EMPTY_LIST;
        File userDir = new File(System.getProperty("user.dir"));
        if (request.isReactorActive()) {
            String includes = System.getProperty("maven.reactor.includes", "**/pom.xml,**/release-pom.xml");
            String excludes = System.getProperty("maven.reactor.excludes", "pom.xml,release-pom.xml");
            files = FileUtils.getFiles(userDir, includes, excludes);
            this.filterOneProjectFilePerDirectory(files);
            Collections.sort(files);
        } else if (request.getPomFile() != null) {
            File projectFile = new File(request.getPomFile()).getAbsoluteFile();
            if (projectFile.exists()) {
                files = Collections.singletonList(projectFile);
            }
        } else {
            File projectFile = new File(userDir, "release-pom.xml");
            if (!projectFile.exists()) {
                projectFile = new File(userDir, "pom.xml");
            }
            if (projectFile.exists()) {
                files = Collections.singletonList(projectFile);
            }
        }
        return files;
    }

    private void filterOneProjectFilePerDirectory(List files) {
        ArrayList<File> releaseDirs = new ArrayList<File>();
        for (File projectFile : files) {
            if (!"release-pom.xml".equals(projectFile.getName())) continue;
            releaseDirs.add(projectFile.getParentFile());
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File projectFile;
            projectFile = (File)it.next();
            if ("release-pom.xml".equals(projectFile.getName()) || !releaseDirs.contains(projectFile.getParentFile())) continue;
            it.remove();
        }
    }
}

