/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.version.report;

import hidden.org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import hidden.org.apache.jackrabbit.webdav.version.DeltaVConstants;
import hidden.org.apache.jackrabbit.webdav.version.report.ReportInfo;
import hidden.org.apache.jackrabbit.webdav.version.report.ReportType;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedReportSetProperty
extends AbstractDavProperty {
    private static Logger log = LoggerFactory.getLogger(SupportedReportSetProperty.class);
    private final HashSet reportTypes = new HashSet();

    public SupportedReportSetProperty() {
        super(DeltaVConstants.SUPPORTED_REPORT_SET, true);
    }

    public SupportedReportSetProperty(ReportType[] reportTypes) {
        super(DeltaVConstants.SUPPORTED_REPORT_SET, true);
        for (int i = 0; i < reportTypes.length; ++i) {
            this.addReportType(reportTypes[i]);
        }
    }

    public void addReportType(ReportType reportType) {
        this.reportTypes.add(reportType);
    }

    public boolean isSupportedReport(ReportInfo reqInfo) {
        Iterator it = this.reportTypes.iterator();
        while (it.hasNext()) {
            ReportType rt = (ReportType)it.next();
            if (!rt.isRequestedReportType(reqInfo)) continue;
            return true;
        }
        return false;
    }

    public Object getValue() {
        return this.reportTypes;
    }

    public Element toXml(Document document) {
        Element elem = this.getName().toXml(document);
        Iterator it = this.reportTypes.iterator();
        while (it.hasNext()) {
            Element sr = DomUtil.addChildElement(elem, "supported-report", DeltaVConstants.NAMESPACE);
            Element r = DomUtil.addChildElement(sr, "report", DeltaVConstants.NAMESPACE);
            r.appendChild(((ReportType)it.next()).toXml(document));
        }
        return elem;
    }
}

